<?php
include "./header.php";

if (getUserAmount("deposits", $conn)) {
  $totalDeposit = getUserAmount("deposits", $conn);
} else {
  $totalDeposit = 0;
}

if (getUserAmount("withdrawals", $conn)) {
  $totalWithdrawal = getUserAmount("withdrawals", $conn);
} else {
  $totalWithdrawal = 0;
}

$amount = $totalDeposit - $totalWithdrawal;

if ($amount < 0) {
  $amount = 0;
}

$savingsBalance = getUserDetails("users", $conn)['balance'] ?? 0;
$sharesBalance = getShares('balance') ?? 0;
?>

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

body {
    background: linear-gradient(135deg, #2664eb, #1e40af);
    min-height: 100vh;
    padding: 2rem;
}

.withdrawal-container {
    max-width: 1200px;
    margin: 0 auto;
}

.page-header {
    text-align: center;
    color: white;
    margin-bottom: 2rem;
}

.page-header h1 {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.page-header p {
    font-size: 1rem;
    opacity: 0.9;
}

.balance-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.balance-card {
    background: white;
    border-radius: 12px;
    padding: 1.5rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.balance-info h5 {
    font-size: 0.9rem;
    color: #6b7280;
    margin-bottom: 0.5rem;
    font-weight: 500;
}

.balance-info h2 {
    font-size: 1.8rem;
    color: #1e293b;
    font-weight: 700;
    margin-bottom: 0.25rem;
}

.balance-info p {
    font-size: 0.85rem;
    color: #22c55e;
    margin: 0;
}

.balance-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #2664eb, #1e40af);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: white;
}

.withdrawal-forms {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(450px, 1fr));
    gap: 2rem;
}

.card {
    background: white;
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    overflow: hidden;
}

.card-header {
    background: linear-gradient(135deg, #2664eb, #1e40af);
    color: white;
    padding: 1.5rem;
}

.card-header h4 {
    font-size: 1.25rem;
    font-weight: 600;
    margin: 0;
}

.card-body {
    padding: 2rem;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 500;
    color: #333;
    font-size: 0.95rem;
}

.form-control, select {
    width: 100%;
    padding: 0.75rem 1rem;
    border: 1px solid #ddd;
    border-radius: 6px;
    font-size: 1rem;
    transition: border-color 0.3s;
}

.form-control:focus, select:focus {
    outline: none;
    border-color: #2664eb;
    box-shadow: 0 0 0 3px rgba(38, 100, 235, 0.2);
}

.input-group {
    display: flex;
    align-items: stretch;
}

.input-group-prepend {
    margin-right: -1px;
}

.input-group-text {
    background: #f3f4f6;
    border: 1px solid #ddd;
    padding: 0.75rem 1rem;
    border-radius: 6px 0 0 6px;
    font-weight: 600;
    color: #555;
}

.input-group .form-control {
    border-radius: 0 6px 6px 0;
}

.btn-primary {
    display: block;
    width: 100%;
    padding: 0.9rem;
    background: linear-gradient(135deg, #2664eb, #1e40af);
    color: white;
    border: none;
    border-radius: 6px;
    font-size: 1.1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #1e40af, #2664eb);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(38, 100, 235, 0.3);
}

.alert-info {
    background-color: #eff6ff;
    border-left: 4px solid #2664eb;
    color: #1e40af;
    padding: 1rem;
    border-radius: 6px;
    margin-bottom: 1.5rem;
    font-size: 0.9rem;
}

@media (max-width: 768px) {
    body {
        padding: 1rem;
    }

    .withdrawal-forms {
        grid-template-columns: 1fr;
    }

    .page-header h1 {
        font-size: 1.5rem;
    }

    .balance-info h2 {
        font-size: 1.5rem;
    }

    .card-body {
        padding: 1.5rem;
    }
}
</style>

<body>
<div class="withdrawal-container">
    <div class="page-header">
        <h1>💰 Withdraw Funds</h1>
        <p>Choose your preferred withdrawal method</p>
    </div>

    <div class="balance-cards">
        <div class="balance-card">
            <div class="balance-info">
                <h5>Savings Balance</h5>
                <h2>$<?= number_format($savingsBalance, 2) ?></h2>
                <p>✓ Available for withdrawal</p>
            </div>
            <div class="balance-icon">
                <i class="fas fa-piggy-bank"></i>
            </div>
        </div>

        <div class="balance-card">
            <div class="balance-info">
                <h5>Shares Balance</h5>
                <h2>$<?= number_format($sharesBalance, 2) ?></h2>
                <p>✓ Available for withdrawal</p>
            </div>
            <div class="balance-icon">
                <i class="fas fa-chart-line"></i>
            </div>
        </div>
    </div>

    <div class="withdrawal-forms">
        <!-- Bank Withdrawal -->
        <div class="card">
            <div class="card-header">
                <h4><i class="fas fa-university"></i> Bank Account Withdrawal</h4>
            </div>
            <div class="card-body">
                <div class="alert-info">
                    <strong>Note:</strong> Bank transfers may take 1-3 business days to process.
                </div>

                <form method="post" action="./scripts/funct.php">
                    <div class="form-group">
                        <label>Bank Name</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <div class="input-group-text"><i class="fas fa-building"></i></div>
                            </div>
                            <input type="text" class="form-control" name="coin" placeholder="Enter your bank name" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Account Number</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <div class="input-group-text"><i class="fas fa-hashtag"></i></div>
                            </div>
                            <input type="text" class="form-control" name="wallet" placeholder="Enter account number" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Select Your Wallet</label>
                        <select class="form-control" name="account" required>
                            <option value="">-- Choose Wallet --</option>
                            <option value="savings">Savings Account</option>
                            <option value="shares">Shares Account</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Amount</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <div class="input-group-text">$</div>
                            </div>
                            <input type="number" class="form-control" name="amount" placeholder="0.00" step="0.01" min="10" required>
                        </div>
                        <small style="color: #6b7280; font-size: 0.85rem; margin-top: 0.25rem; display: block;">
                            Minimum withdrawal: $10.00
                        </small>
                    </div>

                    <button type="submit" name="withdraw" class="btn-primary">
                        <i class="fas fa-check-circle"></i> Withdraw to Bank
                    </button>
                </form>
            </div>
        </div>

        <!-- Crypto Withdrawal -->
        <div class="card">
            <div class="card-header">
                <h4><i class="fab fa-bitcoin"></i> Cryptocurrency Withdrawal</h4>
            </div>
            <div class="card-body">
                <div class="alert-info">
                    <strong>Note:</strong> Crypto withdrawals are processed instantly to your wallet.
                </div>

                <form method="post" action="./scripts/funct.php">
                    <div class="form-group">
                        <label>Wallet Address</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <div class="input-group-text"><i class="fas fa-wallet"></i></div>
                            </div>
                            <input type="text" class="form-control" name="wallet" placeholder="Enter wallet address" required value="<?= getUserDetails('users', $conn)['wallet'] ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Select Coin</label>
                        <select class="form-control" name="coin" required>
                            <option value="">-- Choose Cryptocurrency --</option>
                            <option value="btc">Bitcoin (BTC)</option>
                            <option value="eth">Ethereum (ETH)</option>
                            <option value="lyt">Litecoin (LYT)</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Select Your Wallet</label>
                        <select class="form-control" name="account" required>
                            <option value="">-- Choose Wallet --</option>
                            <option value="savings">Savings Account</option>
                            <option value="shares">Shares Account</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Amount</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <div class="input-group-text">$</div>
                            </div>
                            <input type="number" class="form-control" name="amount" placeholder="0.00" step="0.01" min="10" required>
                        </div>
                        <small style="color: #6b7280; font-size: 0.85rem; margin-top: 0.25rem; display: block;">
                            Minimum withdrawal: $10.00
                        </small>
                    </div>

                    <button type="submit" name="withdraw" class="btn-primary">
                        <i class="fas fa-paper-plane"></i> Withdraw to Crypto
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Form validation
document.querySelectorAll('form').forEach(form => {
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        const amount = this.querySelector('input[name="amount"]').value;
        const account = this.querySelector('select[name="account"]').value;
        
        if (!account) {
            Swal.fire({
                icon: 'error',
                title: 'Selection Required',
                text: 'Please select a wallet to withdraw from'
            });
            return;
        }
        
        if (parseFloat(amount) < 10) {
            Swal.fire({
                icon: 'error',
                title: 'Invalid Amount',
                text: 'Minimum withdrawal amount is $10.00'
            });
            return;
        }
        
        Swal.fire({
            title: 'Confirm Withdrawal',
            html: `You are about to withdraw <strong>$${parseFloat(amount).toFixed(2)}</strong> from your ${account} account`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#2664eb',
            cancelButtonColor: '#ef4444',
            confirmButtonText: 'Yes, Withdraw',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                this.submit();
            }
        });
    });
});
</script>
</body>
</html>