<?php
include "./header.php";

// Get current user's balance
$currentUser = getUserDetails('users', $conn);
$currentBalance = $currentUser['balance'] ?? 0;

if (isset($_GET['message'])): ?>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
    Swal.fire({
      icon: '<?= isset($_GET['error']) ? 'error' : 'success' ?>',
      title: '<?= htmlspecialchars($_GET['message']) ?>',
      showConfirmButton: false,
      timer: 2000
    });
  </script>
<?php endif; ?>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    body {
        background: linear-gradient(135deg, #2664eb, #1e40af);
        min-height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 2rem;
    }

    .card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        width: 100%;
        max-width: 500px;
        overflow: hidden;
        text-align: center;
    }

    .card-header {
        background: linear-gradient(135deg, #2664eb, #1e40af);
        color: white;
        padding: 1.5rem;
    }

    .card-header h4 {
        font-size: 1.5rem;
        font-weight: 600;
        margin: 0;
    }

    .balance-display {
        background: rgba(255, 255, 255, 0.1);
        border-radius: 8px;
        padding: 1rem;
        margin-top: 1rem;
    }

    .balance-display p {
        font-size: 0.9rem;
        margin: 0;
        opacity: 0.9;
    }

    .balance-display h3 {
        font-size: 2rem;
        margin: 0.5rem 0 0 0;
        font-weight: 700;
    }

    .card-body {
        padding: 2rem 1.5rem;
    }

    .form-group {
        margin-bottom: 1.5rem;
        text-align: left;
    }

    .form-group label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 500;
        color: #333;
    }

    .form-control, select {
        width: 100%;
        padding: 0.75rem 1rem;
        border: 1px solid #ddd;
        border-radius: 6px;
        font-size: 1rem;
        transition: border-color 0.3s;
    }

    .form-control:focus, select:focus {
        outline: none;
        border-color: #2664eb;
        box-shadow: 0 0 0 3px rgba(38, 100, 235, 0.2);
    }

    .input-group {
        display: flex;
        align-items: stretch;
    }

    .input-group-prepend {
        margin-right: -1px;
    }

    .input-group-text {
        background: #f3f4f6;
        border: 1px solid #ddd;
        padding: 0.75rem 1rem;
        border-radius: 6px 0 0 6px;
        font-weight: 600;
        color: #555;
    }

    .input-group .form-control {
        border-radius: 0 6px 6px 0;
    }

    .btn-primary {
        display: inline-block;
        padding: 0.9rem;
        background: linear-gradient(135deg, #2664eb, #1e40af);
        color: white;
        border: none;
        border-radius: 6px;
        font-size: 1.1rem;
        font-weight: 500;
        cursor: pointer;
        width: 100%;
        transition: all 0.3s;
    }

    .btn-primary:hover {
        background: linear-gradient(135deg, #1e40af, #2664eb);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(38, 100, 235, 0.3);
    }

    .btn-primary:disabled {
        background: #cbd5e1;
        cursor: not-allowed;
        transform: none;
    }

    .alert {
        padding: 1rem;
        border-radius: 6px;
        margin-bottom: 1.5rem;
        font-size: 0.9rem;
        text-align: left;
    }

    .alert-info {
        background-color: #eff6ff;
        border-left: 4px solid #2664eb;
        color: #1e40af;
    }

    .notes {
        background-color: #eff6ff;
        border-left: 4px solid #2664eb;
        padding: 1rem;
        border-radius: 4px;
        margin-top: 1.5rem;
        font-size: 0.9rem;
        text-align: left;
    }

    .notes ul {
        margin: 0.5rem 0 0 1.2rem;
    }

    .notes li {
        margin-bottom: 0.3rem;
        line-height: 1.4;
    }

    .user-found {
        background: #f0fdf4;
        border: 1px solid #86efac;
        padding: 0.75rem;
        border-radius: 6px;
        margin-top: 0.5rem;
        display: none;
    }

    .user-found.show {
        display: block;
    }

    .user-found-content {
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }

    .user-found-content i {
        color: #22c55e;
        font-size: 1.2rem;
    }

    .user-found-details {
        text-align: left;
    }

    .user-found-details p {
        margin: 0;
        font-size: 0.85rem;
        color: #166534;
    }

    .user-found-details strong {
        font-size: 0.95rem;
        color: #15803d;
    }

    @media (max-width: 576px) {
        body {
            padding: 1rem;
        }

        .card-body {
            padding: 1.5rem;
        }

        .balance-display h3 {
            font-size: 1.5rem;
        }
    }
</style>

<body>
<div class="card">
    <div class="card-header">
        <h4>Transfer Money</h4>
        <div class="balance-display">
            <p>Available Balance</p>
            <h3>$<?= number_format($currentBalance, 2) ?></h3>
        </div>
    </div>

    <form class="card-body" method="post" action="scripts/transfer_process.php" id="transferForm">
        
        <div class="alert alert-info">
            <strong>Transfer funds instantly</strong> to another Pinnex Hub user using their email address.
        </div>

        <div class="form-group">
            <label>Recipient Email Address</label>
            <input type="email" 
                   class="form-control" 
                   name="recipient_email" 
                   id="recipientEmail"
                   placeholder="Enter recipient's email address" 
                   required>
            <div class="user-found" id="userFound">
                <div class="user-found-content">
                    <i class="fas fa-check-circle"></i>
                    <div class="user-found-details">
                        <strong id="recipientName"></strong>
                        <p>User verified ✓</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <label>Transfer Amount</label>
            <div class="input-group">
                <div class="input-group-prepend">
                    <div class="input-group-text">$</div>
                </div>
                <input type="number" 
                       class="form-control" 
                       name="amount" 
                       id="transferAmount"
                       placeholder="0.00" 
                       step="0.01"
                       min="1"
                       max="<?= $currentBalance ?>"
                       required>
            </div>
            <small style="color: #6b7280; font-size: 0.85rem; margin-top: 0.25rem; display: block;">
                Maximum: $<?= number_format($currentBalance, 2) ?>
            </small>
        </div>

        <div class="form-group">
            <label>Transaction PIN (Optional)</label>
            <input type="password" 
                   class="form-control" 
                   name="pin" 
                   placeholder="Enter your 4-digit PIN"
                   maxlength="4"
                   pattern="[0-9]{4}">
            <small style="color: #6b7280; font-size: 0.85rem; margin-top: 0.25rem; display: block;">
                Leave blank if you haven't set a PIN
            </small>
        </div>

        <div class="form-group">
            <label>Description (Optional)</label>
            <textarea class="form-control" 
                      name="description" 
                      rows="3"
                      placeholder="Add a note for this transfer..."
                      maxlength="200"></textarea>
        </div>

        <button type="submit" name="transfer" class="btn-primary" id="submitBtn">
            <i class="fas fa-paper-plane"></i> Transfer Now
        </button>

        <div class="notes">
            <strong>Important Information:</strong>
            <ul>
                <li>Transfers are processed instantly</li>
                <li>Make sure the recipient email is correct</li>
                <li>You cannot transfer more than your available balance</li>
                <li>All transfers are recorded in your transaction history</li>
                <li>Contact support if you have any issues</li>
            </ul>
        </div>
    </form>
</div>

<script>
    // Verify recipient email
    let verifyTimeout;
    document.getElementById('recipientEmail').addEventListener('input', function() {
        const email = this.value;
        const userFoundDiv = document.getElementById('userFound');
        
        clearTimeout(verifyTimeout);
        
        if (email.length > 5 && email.includes('@')) {
            verifyTimeout = setTimeout(() => {
                // AJAX call to verify user
                fetch('scripts/verify_user.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'email=' + encodeURIComponent(email)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('recipientName').textContent = data.fullname;
                        userFoundDiv.classList.add('show');
                    } else {
                        userFoundDiv.classList.remove('show');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    userFoundDiv.classList.remove('show');
                });
            }, 500);
        } else {
            userFoundDiv.classList.remove('show');
        }
    });

    // Validate amount
    document.getElementById('transferAmount').addEventListener('input', function() {
        const maxAmount = <?= $currentBalance ?>;
        const amount = parseFloat(this.value);
        const submitBtn = document.getElementById('submitBtn');
        
        if (amount > maxAmount) {
            this.value = maxAmount;
        }
        
        if (amount <= 0 || isNaN(amount)) {
            submitBtn.disabled = true;
        } else {
            submitBtn.disabled = false;
        }
    });

    // Form submission confirmation
    document.getElementById('transferForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const amount = document.getElementById('transferAmount').value;
        const email = document.getElementById('recipientEmail').value;
        
        Swal.fire({
            title: 'Confirm Transfer',
            html: `You are about to transfer <strong>$${parseFloat(amount).toFixed(2)}</strong> to <strong>${email}</strong>`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#2664eb',
            cancelButtonColor: '#ef4444',
            confirmButtonText: 'Yes, Transfer',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                this.submit();
            }
        });
    });
</script>
</body>
</html>