<?php
include_once "conn.php";
    
function complete_shares($id) {
    global $conn;

    $sql = "SELECT * FROM shares WHERE id = $id";
    $res = $conn->query($sql);
    $row = $res->fetch_assoc();

    $plan = $row['plan'];
    $samount = $row['samount'];
    $registration_id = $row['registration_id'];
    $updated_at = strtotime($row['updated_at']); // Assuming 'updated_at' is a timestamp column

    $rio = 0;
    $required_time = 0;
    switch ($plan) {
        case 'basic':
            $rio = 0.2; 
            $required_time = 24 * 60 * 60; 
            break;
        case 'regular':
            $rio = 0.3; 
            $required_time = 24 * 60 * 60 * 30; 
            break;
        case 'professional':
            $rio = 0.4; 
            $required_time = 24 * 60 * 60 * 30; 
            break;
        case 'premium':
            $rio = 0.5; 
            $required_time = 24 * 60 * 60 * 30; 
            break;
        case 'gold':
            $rio = 1; 
            $required_time = 96 * 60 * 60; 
            break;
        case 'weekend':
            $rio = 0.5; 
            $required_time = 24 * 60 * 60; 
            break;
        default:
            return "<h5 style='color:red'>$id Invalid plan</h5>";
            break;
    }

    $current_time = time();
    $time_elapsed = $current_time - $updated_at;
    

    if ($time_elapsed >= $required_time) {
        // Calculate the total profit over the specified time
        $total_profit = $samount * $rio;

        // Update the users table shares column
        $conn->query("UPDATE users SET shares = shares + $total_profit + $samount WHERE registration_id = '$registration_id'");

        // Update the shares table amount column
        $conn->query("UPDATE shares SET amount = samount + $total_profit, status = 'completed' WHERE id = $id");

        // You can return something here if needed
        return "<h5 style='color:green'>$id Process finished</h5>";

    } else{
        return "<h5 style='color:red'>$id Not due yet</h5>";
    }

}

// This script is run periodically by a cron job

// Select 'active' shares that need to be processed
$sql = "SELECT * FROM shares WHERE status = 'active'";
$res = $conn->query($sql);

while ($row = $res->fetch_assoc()) {
    $share_id = $row['id'];
    echo complete_shares($share_id);
}
