  <?php 
  include "./header.php";
  $user = getUserDetails('users',$conn);
  ?>

  <div class="min-h-screen bg-gray-50 pt-20 px-4 md:px-10">

    <div class="max-w-6xl mx-auto space-y-10">

      <!-- Profile Header Card -->
      <div class="bg-white rounded-2xl shadow-lg p-8 flex flex-col md:flex-row items-center md:items-start gap-6">
        
        <!-- Profile Picture -->
        <div class="flex-shrink-0 text-center md:text-left">
          <img src="./profileImages/<?= $user['profile_pic'];?>" 
              alt="Profile" 
              class="w-32 h-32 mx-auto md:mx-0 rounded-full border-4 border-blue-500 shadow-sm">
          <h2 class="mt-4 text-2xl font-bold text-black"><?= $user['fullname']; ?></h2>
          <p class="text-gray-500 mt-1">Investor</p>

          <!-- Change Profile Picture -->
          <form method="post" action="./scripts/funct.php" enctype="multipart/form-data" class="mt-4 space-y-2">
            <input type="file" name="picture" class="w-full text-sm text-black border rounded-lg p-2">
            <input type="submit" name="updateImage" value="Upload" 
                  class="w-full text-white font-semibold py-2 rounded-lg cursor-pointer"
                  style="background: linear-gradient(to right, #2563eb, #1e3a8a);">
          </form>
        </div>

        <!-- Personal Info -->
        <div class="flex-1 grid grid-cols-1 md:grid-cols-2 gap-6">
          <div class="bg-gray-50 rounded-xl p-4 flex flex-col space-y-2">
            <span class="text-gray-400 text-sm">Registration ID</span>
            <span class="text-black font-medium"><?= $user['registration_id']; ?></span>
          </div>
          <div class="bg-gray-50 rounded-xl p-4 flex flex-col space-y-2">
            <span class="text-gray-400 text-sm">Referral Code</span>
            <span class="text-black font-medium"><?= $user['referral_code']; ?></span>
          </div>
          <div class="bg-gray-50 rounded-xl p-4 flex flex-col space-y-2">
            <span class="text-gray-400 text-sm">Email</span>
            <span class="text-black font-medium"><?= $user['email']; ?></span>
          </div>
          <div class="bg-gray-50 rounded-xl p-4 flex flex-col space-y-2">
            <span class="text-gray-400 text-sm">Wallet</span>
            <span class="text-black font-medium"><?= $user['wallet']; ?></span>
          </div>
        </div>

      </div>

      <!-- Edit Profile Form -->
      <div class="bg-white rounded-2xl shadow-lg p-8">
        <h3 class="text-xl font-bold text-black mb-6">Edit Profile</h3>

        <form method="post" class="space-y-6">

          <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
              <label class="block text-sm font-medium text-black mb-1">Full Name</label>
              <input type="text" name="userName" value="<?= $user['fullname'];?>" 
                    class="w-full border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-400 focus:outline-none text-black">
            </div>
            <div>
              <label class="block text-sm font-medium text-black mb-1">Email</label>
              <input type="email" name="userEmail" value="<?= $user['email'];?>" 
                    class="w-full border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-400 focus:outline-none text-black">
            </div>
          </div>

          <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
              <label class="block text-sm font-medium text-black mb-1">Update Withdrawal Account</label>
              <input type="text" name="wallet" value="<?= $user['wallet'];?>" 
                    class="w-full border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-400 focus:outline-none text-black">
            </div>
            <div>
              <label class="block text-sm font-medium text-black mb-1">New Password</label>
              <input type="password" name="password" value="<?= $user['password'];?>" 
                    class="w-full border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-blue-400 focus:outline-none text-black">
            </div>
          </div>

          <!-- Robot Confirmation -->
          <div class="flex items-center gap-3">
            <input type="checkbox" name="remember" id="newsletter" class="h-4 w-4 rounded border-gray-300">
            <label for="newsletter" class="text-black text-sm">I am not a robot</label>
          </div>
          <p class="text-gray-400 text-sm">Your details are safe with us.</p>

          <!-- Submit -->
          <button type="submit" name="updateProfile" 
                  class="w-full text-white font-semibold py-2 rounded-lg cursor-pointer shadow"
                  style="background: linear-gradient(to right, #2563eb, #1e3a8a);">
            Save Changes
          </button>
        </form>
      </div>

    </div>
  </div>
