<?php
session_start();

include './conn.php';

// to avoid sql injections
function test_input($data)
{
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

//to generate Random numbers
function randomGen($min, $max, $quantity)
{
    $numbers = range($min, $max);
    shuffle($numbers);
    return array_slice($numbers, 0, $quantity);
}

function encrypt_decrypt($string, $action = 'encrypt')
{
    $encrypt_method = "AES-256-CBC";
    $secret_key = 'AA74CDCCrferefesc2BBRT935136HH7B63C27'; // user define private key
    $secret_iv = '5fgf54645dsfdfsfc5HJ5g27'; // user define secret key
    $key = hash('sha256', $secret_key);
    $iv = substr(hash('sha256', $secret_iv), 0, 16); // sha256 is hash_hmac_algo
    if ($action == 'encrypt') {
        $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
        $output = base64_encode($output);
    } else if ($action == 'decrypt') {
        $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
    }
    return $output;
}

//registration

if (isset($_POST["register"])) {

    $registration_id = implode("", randomGen(0, 20, 10));
    $referral_code = implode("", randomGen(0, 10, 10));
    $fname = test_input($_POST['first_name']);
    $lname = test_input($_POST['last_name']);
    $fullname = $fname . " " . $lname;
    $email = test_input($_POST['email']);
    $password = test_input($_POST['password']);
    $confirm_password = test_input($_POST['confirm_password']);
    $package = "Basic";
    $wallet = test_input($_POST['wallet_address']);
    $referree_code = test_input($_POST['referralCode']);
    $registration_date = date('Y-m-d');
    $password_hash = encrypt_decrypt($password, 'encrypt');

    if ($password != $confirm_password) {
        header("location:../auth-register.php?message=password is not matched, please try again");
        exit();
    } else {
        // Check if email already exists
        $check_email = "SELECT * FROM `users` WHERE `email` = '$email'";
        $email_result = $conn->query($check_email);
        
        if ($email_result->num_rows > 0) {
            header("location:../auth-register.php?message=Email already registered");
            exit();
        }
        
        $sql = "INSERT INTO `users` (`registration_id`, `fullname`, `email`, `password`, `package`, `wallet`, `registration_date`,`referral_code`, `referee_code`) VALUES ('$registration_id', '$fullname', '$email', '$password_hash', '$package', '$wallet', '$registration_date','$referral_code','$referree_code')";

        if ($conn->query($sql)) {
            
            // Send welcome email
            $from = "arbitrageltd@arbitrage-ltd.com";
            $to = $email;
            $subject = "Welcome to Arbitrage Limited - Registration Successful";
            
            $message = "
            <html>
            <head>
                <title>Welcome to Arbitrage Limited</title>
                <style>
                    body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                    .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                    .header { background: linear-gradient(to right, #2563eb, #1e3a8a); padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
                    .header img { max-width: 200px; height: auto; }
                    .content { background: #ffffff; padding: 30px; border: 1px solid #e5e7eb; }
                    .credentials { background: #f3f4f6; padding: 20px; border-radius: 8px; margin: 20px 0; }
                    .credentials strong { color: #2563eb; }
                    .footer { background: #f9fafb; padding: 20px; text-align: center; border-radius: 0 0 10px 10px; font-size: 12px; color: #6b7280; }
                    .button { display: inline-block; padding: 12px 30px; background: linear-gradient(to right, #2563eb, #1e3a8a); color: white; text-decoration: none; border-radius: 8px; margin: 20px 0; }
                </style>
            </head>
            <body>
                <div class='container'>
                    <div class='header'>
                        <img src='https://arbitrage-ltd.com/assets/img/logo.png' alt='Arbitrage Limited Logo'>
                    </div>
                    
                    <div class='content'>
                        <h2 style='color: #2563eb;'>Welcome to Arbitrage Limited, $fullname!</h2>
                        
                        <p>Congratulations! Your registration has been successfully completed.</p>
                        
                        <p>We're excited to have you as part of our investment community. You can now access your dashboard and start exploring our investment packages.</p>
                        
                        <div class='credentials'>
                            <h3 style='margin-top: 0;'>Your Login Credentials:</h3>
                            <p><strong>Email/Username:</strong> $email</p>
                            <p><strong>Registration ID:</strong> $registration_id</p>
                            <p><strong>Referral Code:</strong> $referral_code</p>
                            <p style='color: #dc2626; font-size: 14px;'><em>Please keep your password safe and never share it with anyone.</em></p>
                        </div>
                        
                        <p><strong>Next Steps:</strong></p>
                        <ul>
                            <li>Login to your dashboard</li>
                            <li>Complete your profile</li>
                            <li>Explore investment packages</li>
                            <li>Start investing</li>
                        </ul>
                        
                        <div style='text-align: center;'>
                            <a href='https://arbitrage-ltd.com/auth-login.php' class='button'>Login to Dashboard</a>
                        </div>
                        
                        <p>If you have any questions or need assistance, please don't hesitate to contact our support team.</p>
                        
                        <p>Best regards,<br>
                        <strong>Arbitrage Limited Team</strong></p>
                    </div>
                    
                    <div class='footer'>
                        <p>This is an automated message, please do not reply to this email.</p>
                        <p>&copy; " . date('Y') . " Arbitrage Limited. All rights reserved.</p>
                    </div>
                </div>
            </body>
            </html>";
            
            // Set email headers
            $headers = "From: Arbitrage Limited <$from>\r\n";
            $headers .= "Reply-To: $from\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-type: text/html; charset=UTF-8\r\n";
            $headers .= "X-Mailer: PHP/" . phpversion();
            
            // Send email
            $email_sent = mail($to, $subject, $message, $headers);
            
            // Redirect regardless of email status (but you can log if email fails)
            if (!$email_sent) {
                // Log error or store in database for retry
                error_log("Failed to send registration email to: $email");
            }
            
            header("location:../auth-login.php?message=Registration Successful! Please check your email and login");
            exit();
            
        } else {
            header("location:../auth-register.php?message=Registration failed, please try again");
            error_log("Registration Error: " . $conn->error);
            exit();
        }
    }
}

//login

if (isset($_POST["login"])) {

    $email = test_input($_POST['email']);

    $password = test_input($_POST['password']);

    $sql = "SELECT * FROM `users` WHERE `email` = '$email' ";

    $result = $conn->query($sql);

    if ($result->num_rows > 0) {

        $row = $result->fetch_assoc();

        $userPassword =  encrypt_decrypt($row["password"], 'decrypt');

        if ($userPassword == $password) {

            $_SESSION["id"] = $row['registration_id'];

            echo $_SESSION["id"];

            header("location:../../User-dashboard");
            exit();
        } else {
            header("location:../auth-login.php?message=Wrong password");
            exit();
        }
    } else {
        header("location:../auth-login.php?message=Wrong Details");
        exit();
    }
}
?>