<?php 

include "./header.php";

function pendingAmount($table){
  global $conn;
  $id = $_SESSION['id'];
  $sql = "SELECT * FROM $table WHERE status = 'pending' AND registration_id = '$id'";
  $res = $conn->query($sql);
  $balance = 0;
  while ($row = $res->fetch_assoc()) {
      $balance += $row['amount'];
  }
  return $balance;
}

$monthArray = json_encode(getArray('months'));
$incomeArray = json_encode(getArray('income'));
$depositArray = json_encode(getArray('samount'));
$max = max(array_merge(getArray('income'), getArray('samount')));

if (getUserAmount("deposits",$conn)) {
  $totalDeposit = getUserAmount("deposits",$conn);
} else {
  $totalDeposit = 0;
}

if (getUserAmount("withdrawals",$conn)) {
  $totalWithdrawal = getUserAmount("withdrawals",$conn);
} else {
  $totalWithdrawal = 0;
}

$amount = $totalDeposit - $totalWithdrawal;

if ($amount < 0) {
    $amount = 0;
}
?>

<!-- ✅ Flash Message -->
<?php if (isset($_GET['message'])): ?>
 <div id="flashMessage" 
       style="position:fixed; top:50%; left:50%; transform:translate(-50%, -50%);
              background:linear-gradient(90deg, #2664eb, #1e40af);
              color:white; padding:16px 32px; border-radius:12px;
              box-shadow:0 6px 15px rgba(0,0,0,0.25);
              font-size:1rem; font-weight:600; text-align:center; z-index:9999;">
    <?= htmlspecialchars($_GET['message']); ?>
  </div>
<?php endif; ?>

<script>
  setTimeout(() => {
    const box = document.getElementById("flashMessage");
    if (box) {
      box.style.transition = "opacity 0.6s ease";
      box.style.opacity = "0";
      setTimeout(() => box.remove(), 600);
    }
  }, 2000); // disappears after 2 seconds
</script>
<!-- Main Content -->
<div class="main-content">
  <section class="section">
    <div class="row">
      <!-- White Container Card -->
      <div class="bg-white border border-gray-200 rounded-2xl shadow-lg p-8 w-full">
        
        <!-- Header Row -->
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-8">
          <!-- Left: Greeting -->
          <div>
            <h2 class="text-xl font-bold text-gray-800 flex items-center gap-2">
              Good morning  <?=getUserDetails('users',$conn)['fullname'];?> 👋
            </h2>
            <p class="text-gray-500 text-sm">
              Welcome, Here's an overview of your finances.
            </p>
          </div>
          
          <!-- Right: Button -->
          <!-- Responsive Export Button -->
<div class="flex justify-center md:justify-end w-full">
  <button class="w-full max-w-xs md:w-auto mt-4 md:mt-0 bg-black text-white px-6 py-2 rounded-xl font-medium hover:bg-gray-800">
    Plans
  </button>
</div>

        </div>

       <!-- ✅ Grid with 3 Cards inside -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-8 w-full">
  
  <!-- Total Balance -->
  <div class="bg-gradient-to-r from-blue-500 to-blue-800 text-white rounded-2xl p-8 flex flex-col justify-between" style="background: linear-gradient(to right, #2664eb, #1e40af);">
    <div>
      <p class="text-base opacity-80 flex items-center gap-2">
        <span class="p-2 rounded-full bg-white/20 flex items-center justify-center">
          <svg xmlns="http://www.w3.org/2000/svg" 
               fill="none" viewBox="0 0 24 24" 
               stroke-width="1.5" stroke="currentColor" 
               class="w-5 h-5 text-white">
            <path stroke-linecap="round" stroke-linejoin="round" 
                  d="M21 12.75V6a2.25 2.25 0 00-2.25-2.25H6A2.25 2.25 0 003.75 6v12A2.25 2.25 0 006 20.25h12.75A2.25 2.25 0 0021 18v-5.25z" />
            <path stroke-linecap="round" stroke-linejoin="round" 
                  d="M15 12.75h6.75v-1.5H15v1.5z" />
          </svg>
        </span>
        Savings Balance
      </p>

      <h2 class="text-4xl font-bold mt-2 text-white">
        $<?= getUserDetails("users", $conn)['balance'] ?? 0 ?>
        <span class="text-gray-200 opacity-70">.00</span>
      </h2>

      <p class="text-sm mt-2 flex items-center gap-2">
        <span class="bg-white/20 px-3 py-1 rounded-full text-xs">+41%</span> Growth
      </p>
    </div>

    <!-- ✅ Button Group -->
    <div class="flex gap-3 mt-8 justify-center flex-wrap">
      <!-- Deposit -->
      <a href="deposit.php">
        <button class="min-w-[120px] max-w-[140px] bg-white text-black font-semibold px-5 py-2 rounded-xl hover:bg-gray-100 flex items-center justify-center gap-2">
          <i class="fa-solid fa-arrow-up-right-from-square"></i>
          Deposit
        </button>
      </a>
      <!-- Withdraw -->
      <a href="withdrawal.php">
        <button class="min-w-[120px] max-w-[140px] bg-blue-900/50 text-white font-semibold px-5 py-2 rounded-xl hover:bg-blue-800 flex items-center justify-center gap-2">
          <i class="fa-solid fa-arrow-down"></i>
          Withdraw
        </button>
      </a>
    </div>
  </div>

  <!-- Investment Balance -->
  <div class="bg-gray-100 rounded-2xl p-8 flex flex-col justify-between">
    <div class="flex items-center justify-between">
      <p class="text-base text-gray-500 flex items-center gap-2">
        <span class="p-2 rounded-full bg-gray-200 flex items-center justify-center">
          <svg xmlns="http://www.w3.org/2000/svg" 
               fill="none" viewBox="0 0 24 24" 
               stroke-width="1.5" stroke="currentColor" 
               class="w-6 h-6 text-black">
            <path stroke-linecap="round" stroke-linejoin="round" 
                  d="M9 6V4.5A1.5 1.5 0 0110.5 3h3A1.5 1.5 0 0115 4.5V6m-6 0h6m-9 0h12a1.5 1.5 0 011.5 1.5V18a1.5 1.5 0 01-1.5 1.5H6A1.5 1.5 0 014.5 18V7.5A1.5 1.5 0 016 6z" />
          </svg>
        </span>
        Investment Balance
      </p>
    </div>

    <h2 class="text-4xl font-bold text-gray-800 mt-12">
      $<?= getUserDetails("users", $conn)['shares'] ?? 0 ?>
      <span class="text-gray-300">.00</span>
    </h2>

    <p class="text-sm flex items-center gap-2">
      <span class="bg-green-200 px-3 py-1 rounded-full text-xs text-green-500">+10%</span> 
      <span class="text-gray-700">This month</span>
    </p>
  </div>

  <!-- Total Income -->
  <div class="bg-gray-100 rounded-2xl p-8 flex flex-col justify-between">
    <div class="flex items-center justify-between">
      <p class="text-base text-gray-500 flex items-center gap-2">
        <span class="p-2 rounded-full bg-gray-200 flex items-center justify-center">
          <svg xmlns="http://www.w3.org/2000/svg" 
               fill="none" viewBox="0 0 24 24" 
               stroke-width="1.5" stroke="currentColor" 
               class="w-5 h-5 text-black">
            <path stroke-linecap="round" stroke-linejoin="round" 
                  d="M12 6v6h4.5m4.5 0A9 9 0 11 3 12a9 9 0 0118 0z" />
          </svg>
        </span>
        Total Income
      </p>
    </div>

    <h2 class="text-4xl font-bold text-gray-800 mt-12">
      $<?= getUserDetails("users", $conn)['profit'] ?? 0 ?>
      <span class="text-gray-300">.00</span>
    </h2>

    <p class="text-sm flex items-center gap-2">
      <span class="bg-red-200 px-3 py-1 rounded-full text-xs text-red-500">-4%</span> 
      <span class="text-gray-700">This month</span>
    </p>
  </div>

</div>

  </section>


 <br>
 <br>
 <br>
   <!-- ROW 2: Chart + Side Card -->
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6 items-start -mt-8"> <!-- negative margin to overlap Row 1 shadow -->

<!-- Transaction Overview Card -->
<div class="lg:col-span-2 bg-white rounded-lg shadow flex flex-col" style="height: 500px;">
  <!-- Card Header -->
  <div class="flex justify-between items-center p-4 border-b border-gray-200">
    <div>
      <h4 class="text-xl font-bold text-gray-800">Transaction Overview</h4>
      <div class="flex items-center gap-2 mt-1">
      <h2 class="font-bold text-2xl text-black">
  $<?= number_format((getUserDetails("users", $conn)['shares'] ?? 0) + (getUserDetails("users", $conn)['balance'] ?? 0), 0) ?>
  <span class="text-gray-400">.00</span>
</h2>

        <span class="text-green-600 bg-green-100 px-2 py-0.5 rounded-full text-sm font-medium">+4%</span>
      </div>
    </div>

    <div class="flex flex-col items-end gap-2">
      <select class="border border-gray-300 rounded-lg text-sm px-3 py-1 focus:outline-none text-gray-700">
        <option selected>Month</option>
        <option>Week</option>
        <option>Year</option>
      </select>

      <div class="flex gap-4 text-sm font-medium text-gray-600">
        <div class="flex items-center gap-2">
          <span class="w-2.5 h-2.5 rounded-full bg-red-500"></span> Earnings
        </div>
        <div class="flex items-center gap-2">
          <span class="w-2.5 h-2.5 rounded-full bg-green-500"></span> Spending
        </div>
      </div>
    </div>
  </div>

  <!-- Card Body -->
  <div class="p-4 flex-1">
    <div class="w-full h-[260px] relative"> <!-- reduced height -->
      <canvas id="myChart3" class="w-full h-full object-contain"></canvas>
    </div>
  </div>
</div>

<!-- Recent Transactions Card -->
<div class="lg:col-span-1 bg-white rounded-lg shadow flex flex-col" style="height: 500px;">
  <!-- Widget Header -->
  <div class="border-b border-gray-200 px-6 py-3 flex justify-between items-center">
    <h4 class="text-lg font-bold text-gray-800">Recent Transactions</h4>
    <a href="transactions.php" class="font-semibold hover:underline text-sm" style="color: #2664eb;">View All</a>
  </div>

  <!-- Widget Body -->
  <div class="p-6 space-y-4 overflow-y-auto flex-1">
    <?php
      $id = $_SESSION['id'];

      $deposits = $conn->query("SELECT *, 'Deposit' AS transaction_type FROM `deposits` 
                              WHERE `registration_id` = '$id' 
                              ORDER BY date DESC LIMIT 5");

      $withdrawals = $conn->query("SELECT *, 'Withdrawal' AS transaction_type FROM `withdrawals` 
                                 WHERE `registration_id` = '$id' 
                                 ORDER BY date DESC LIMIT 5");

      $allTransactions = [];

      if ($deposits !== false) {
        while ($row = mysqli_fetch_array($deposits)) {
          $allTransactions[] = $row;
        }
      }

      if ($withdrawals !== false) {
        while ($row = mysqli_fetch_array($withdrawals)) {
          $allTransactions[] = $row;
        }
      }

      usort($allTransactions, fn($a, $b) => strtotime($b['date']) - strtotime($a['date']));

      if (!empty($allTransactions)):
        foreach (array_slice($allTransactions, 0, 8) as $row):
          $transactionType = $row['transaction_type'];
          $amountSign = ($transactionType === 'Deposit') ? '+' : '-';
          $bgColor = ($transactionType === 'Deposit') ? 'bg-blue-50 border-blue-200 text-blue-700' : 'bg-red-50 border-red-200 text-red-700';
    ?>
      <div class="border rounded-xl p-4 flex justify-between items-center shadow-sm <?= $bgColor ?> border">
        <div>
          <p class="text-sm font-semibold"><?= $transactionType ?></p>
          <p class="text-xs mt-1 text-gray-500"><?= $row['coin'] ?? 'USD' ?> • <?= date("d/m/Y", strtotime($row['date'])) ?></p>
        </div>
        <div class="text-right">
          <h2 class="text-lg font-bold"><?= $amountSign ?>$<?= number_format($row['amount'],2) ?></h2>
          <p class="text-xs font-medium mt-1 uppercase"><?= $row['status'] ?></p>
        </div>
      </div>
    <?php
        endforeach;
      else:
    ?>
      <div class="text-center text-gray-400 py-10">
        <p>No transactions available</p>
      </div>
    <?php endif; ?>
  </div>
</div>
</div>

<!-- Chart.js Script -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const ctx = document.getElementById('myChart3').getContext('2d');

new Chart(ctx, {
type: 'line',
data: {
  labels: ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'],
  datasets: [
    {
      label: 'Earnings',
      data: [10000,15000,12000,20000,25000,1983,17000,14000,16000,13000,15000,20000],
      borderColor: '#2664eb',
      borderWidth: 2,
      tension: 0.4,
      fill: false,
      pointRadius: 0
    },
    {
      label: 'Spending',
      data: [15000,17000,18000,22000,28000,30000,27000,26000,25000,24000,23000,29000],
      borderColor: '#22c55e',
      borderWidth: 2,
      tension: 0.4,
      fill: false,
      pointRadius: 0
    }
  ]
},
options: {
  maintainAspectRatio: false,
  responsive: true,
  plugins: {
    legend: { display: false },
    tooltip: {
      mode: 'index',
      intersect: false,
      backgroundColor: '#fff',
      titleColor: '#000',
      bodyColor: '#333',
      borderColor: '#ddd',
      borderWidth: 1,
      padding: 12,
      callbacks: {
        label: function(context) {
          return `$${context.formattedValue}`;
        }
      }
    }
  },
  interaction: { mode: 'nearest', axis: 'x', intersect: false },
  scales: {
    x: {
      ticks: {
        autoSkip: false,
        maxRotation: 0,
        minRotation: 0,
        color: '#6b7280'
      },
      grid: { display: false }
    },
    y: {
      ticks: { color: '#6b7280' },
      grid: { color: '#f3f4f6' }
    }
  }
}
});
</script>




<br>
<br>
<br>
<br>


<section class="section">
          <div class="section-body">
            <div class="row">
              <div class="col-12">
                <div class="card">
                  <div class="card-header">
                  <h4 class="text-xl font-bold text-gray-800">Recent Activities</h4>
                  </div>
                  <div class="card-body">
                    <div class="table-responsive">
                      <table class="table table-striped" id="table-1">
                        <thead>
                          <tr>
                            <th class="text-center">
                              #
                            </th>
                            <th>Deposit Plan</th>
                            <th>Amount Deposited</th>
                            <th>Start Date</th>
                            <th>Due Date</th>
                            <th>Status</th>
                            <th>Action</th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                            $id = $_SESSION['id'];
                            $sql = "SELECT * FROM shares WHERE registration_id = '$id' AND status <> 'pending'";
                            $res = $conn->query($sql);
                            $sn=0;
                            while ($row = $res->fetch_assoc()) {$sn++;?>
                          <tr>
                            <td>
                              <?=$sn?>
                            </td>
                            <td style="text-transform: capitalize;"><?=$row['plan']?></td>
                            <td>
                              <?=$row['samount']?>
                            </td>
                            <td><?php $date = new DateTime($row['created_at']); echo $date->format("Y-d-m")?></td>
                            <td><?php $date = new DateTime($row['due_date']); echo $date->format("Y-d-m")?></td>
                            <td>
                              
                                <?php
                                    
                                    updateShareStatus($conn, $row['transaction_id']);
                                  if($row['status'] == 'active'){
                                    echo "<div class='badge badge-warning badge-shadow'>In Progress</div>";
                                  }else if($row['status'] == 'completed'){
                                    echo "<div class='badge badge-success badge-shadow'>Completed</div>";
                                  }
                                ?>
                            </td>
                            <td>
  <a href="withdrawal.php" 
     class="btn text-white font-semibold" 
     style="background: linear-gradient(to right, #2664eb, #1e40af); border: none;">
    Withdraw
  </a>
</td>

                          </tr>
                         <?php }?>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
           
          </div>
        </section>


    

              
            </div>
          
           
            
          </div>
        </section>
 <!-- General JS Scripts -->
 <script>
    var monthArr = <?=$monthArray?>;
    var incomeArr = <?=$incomeArray?>;
    var depositArr = <?=$depositArray?>;
    var max = <?=$max?>
 </script>
  <script src="assets/js/app.min.js"></script>
  <!-- JS Libraies -->
  <script src="assets/bundles/apexcharts/apexcharts.min.js"></script>
  <!-- Page Specific JS File -->
  <script src="assets/js/page/index.js"></script>
  <!-- Template JS File -->
  <script src="assets/js/scripts.js"></script>
   <!-- JS Libraies -->
   <script src="assets/bundles/chartjs/chart.min.js"></script>
    <script src="assets/bundles/jquery.sparkline.min.js"></script>

    <script src="assets/bundles/jqvmap/dist/jquery.vmap.min.js"></script>
    <script src="assets/bundles/jqvmap/dist/maps/jquery.vmap.world.js"></script>
    <script src="assets/bundles/jqvmap/dist/maps/jquery.vmap.indonesia.js"></script>
  <!-- Custom JS File -->
  <script src="assets/js/custom.js"></script>


  <script src="assets/js/page/widget-chart.js"></script>
    <!-- General JS Scripts -->
    <script src="assets/js/app.min.js"></script>
  <!-- JS Libraies -->
  <script src="assets/bundles/chartjs/chart.min.js"></script>
  <script src="assets/bundles/jquery.sparkline.min.js"></script>
  <script src="assets/bundles/apexcharts/apexcharts.min.js"></script>
  <script src="assets/bundles/jqvmap/dist/jquery.vmap.min.js"></script>
  <script src="assets/bundles/jqvmap/dist/maps/jquery.vmap.world.js"></script>
  <script src="assets/bundles/jqvmap/dist/maps/jquery.vmap.indonesia.js"></script>
  <!-- Page Specific JS File -->
  <script src="assets/js/page/widget-chart.js"></script>
  <!-- Template JS File -->
  <script src="assets/js/scripts.js"></script>
  <!-- Custom JS File -->
  <script src="assets/js/custom.js"></script>
</body>


<!-- index.php  21 Nov 2019 03:47:04 GMT -->
</html>