<?php
include "./header.php";
$sql = "SELECT * FROM admin";
$res = $conn->query($sql);
$ADMIN = $res->fetch_assoc();

if (isset($_GET['message'])): ?>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
    Swal.fire({
      icon: 'success',
      title: '<?= htmlspecialchars($_GET['message']) ?>',
      showConfirmButton: false,
      timer: 2000
    });
  </script>
<?php endif; ?>


<!-- Main Content -->
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    body {
        background: linear-gradient(135deg, #2664eb, #1e40af);
        min-height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        padding: 2rem;
    }

    .card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        width: 100%;
        max-width: 450px;
        overflow: hidden;
        text-align: center;
    }

    .card-header {
        background: linear-gradient(135deg, #2664eb, #1e40af);
        color: white;
        padding: 1.2rem 1.5rem;
    }

    .card-header h4 {
        font-size: 1.4rem;
        font-weight: 600;
        margin: 0;
    }

    .card-body {
        padding: 2rem 1.5rem;
    }

    .form-group {
        margin-bottom: 1.5rem;
        text-align: left;
    }

    .form-group label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 500;
        color: #333;
    }

    .form-control, select {
        width: 100%;
        padding: 0.75rem 1rem;
        border: 1px solid #ddd;
        border-radius: 6px;
        font-size: 1rem;
        transition: border-color 0.3s;
    }

    .form-control:focus, select:focus {
        outline: none;
        border-color: #2664eb;
        box-shadow: 0 0 0 3px rgba(38, 100, 235, 0.2);
    }

    .btn-primary {
        display: inline-block;
        padding: 0.9rem;
        background: linear-gradient(135deg, #2664eb, #1e40af);
        color: white;
        border: none;
        border-radius: 6px;
        font-size: 1.1rem;
        font-weight: 500;
        cursor: pointer;
        width: 100%;
        transition: background 0.3s;
    }

    .btn-primary:hover {
        background: linear-gradient(135deg, #1e40af, #2664eb);
    }

    .notes {
        background-color: #eff6ff;
        border-left: 4px solid #2664eb;
        padding: 1rem;
        border-radius: 4px;
        margin-top: 1.5rem;
        font-size: 0.9rem;
        text-align: left;
    }

    .notes ul {
        margin: 0.5rem 0 0 1.2rem;
    }

    .notes li {
        margin-bottom: 0.3rem;
        line-height: 1.4;
    }

    @media (max-width: 576px) {
        body {
            padding: 1rem;
        }

        .card-body {
            padding: 1.5rem;
        }
    }
</style>

<body>
<div class="card">
    <div class="card-header">
    <div class="card-header bg-gradient-to-r from-blue-600 to-blue-800 text-center" style="background: linear-gradient(to right, #2664eb, #1e40af);">
    <h4 class="text-white font-semibold">Make a Deposit</h4>
</div>

    </div>
    <form class="card-body" method="post" action="./scripts/funct.php">
        <div class="form-group">
            <label>Select Account</label>
            <select class="form-control" name="account" id="accountType" required>
                <option value="savings">Savings Account</option>
                <option value="investment">Investment Account</option>
            </select>
        </div>

        <!-- Plan Selection -->
        <div class="form-group" id="planSelection" style="display:none;">
            <label>Select Plan</label>
            <select class="form-control" name="package" required>
                <option value="basic">Recruit (Mini 100- max 999)</option>
                <option value="standard">stan (Mini 1000- max $9999)</option>
                <option value="advance">Honorarium Plan Mini (10,000- max $99,999)</option>
0000000                <option value="master">Terminal (Mini 100000- max $1)</option>
                <option value="premium">Mining Mini 2000- max 
$100000000)</option>
            </select>
        </div>

        <div class="form-group">
            <label>Amount To Deposit</label>
            <div class="input-group">
                <div class="input-group-prepend">
                    <div class="input-group-text">$</div>
                </div>
                <input type="text" class="form-control" name="amount" placeholder="Amount (USD)" required>
            </div>
        </div>

        <div class="form-group">
            <label>Payment Method</label>
            <select class="form-control" name="coin" id="paymentMethod" required>
                <option value="">-- Select Payment Method --</option>
                <option value="btc">BTC</option>
                <option value="eth">ETHEREUM</option>
                <option value="usdt">USDT</option>
            </select>
        </div>

        <!-- BTC Address Field -->
        <div class="form-group address-field" id="btcAddressField" style="display:none;">
            <label>Bitcoin (BTC) Wallet Address</label>
            <div class="input-group">
                <input type="text" class="form-control" id="btcAddressInput" value="<?= htmlspecialchars($ADMIN['btcAddress'] ?? '') ?>" readonly>
                <div class="input-group-append">
                    <button class="btn btn-primary" type="button" onclick="copyAddress('btcAddressInput')">
                        Copy
                    </button>
                </div>
            </div>
        </div>

        <!-- ETH Address Field -->
        <div class="form-group address-field" id="ethAddressField" style="display:none;">
            <label>Ethereum (ETH) Wallet Address</label>
            <div class="input-group">
                <input type="text" class="form-control" id="ethAddressInput" value="<?= htmlspecialchars($ADMIN['lytAddress'] ?? '') ?>" readonly>
                <div class="input-group-append">
                    <button class="btn btn-primary" type="button" onclick="copyAddress('ethAddressInput')">
                        Copy
                    </button>
                </div>
            </div>
        </div>

        <!-- USDT Address Field -->
        <div class="form-group address-field" id="usdtAddressField" style="display:none;">
            <label>USDT Wallet Address</label>
            <div class="input-group">
                <input type="text" class="form-control" id="usdtAddressInput" value="<?= htmlspecialchars($ADMIN['ethAccount'] ?? '') ?>" readonly>
                <div class="input-group-append">
                    <button class="btn btn-primary" type="button" onclick="copyAddress('usdtAddressInput')">
                        Copy
                    </button>
                </div>
            </div>
        </div>

        <div class="form-group">
            <label>Transaction ID</label>
            <input type="text" class="form-control" name="transaction_id" placeholder="Enter transaction ID" required>
        </div>

        <input type="submit" name="deposit" value="Deposit" class="btn-primary">

        <div class="notes">
            <strong>Important Notes:</strong>
            <ul>
                <li>Deposits are typically processed within 1-2 business days</li>
                <li>Please ensure you're sending funds from a wallet you own</li>
                <li>Contact support if you need assistance with your deposit</li>
            </ul>
        </div>
    </form>
</div>

<script>
    // Show plan selection when investment account is selected
    document.getElementById('accountType').addEventListener('change', function() {
        document.getElementById('planSelection').style.display = this.value === 'investment' ? 'block' : 'none';
    });

    // Show address field based on payment method
    document.getElementById('paymentMethod').addEventListener('change', function() {
        document.querySelectorAll('.address-field').forEach(el => el.style.display = 'none');
        if (this.value === 'btc') document.getElementById('btcAddressField').style.display = 'block';
        if (this.value === 'eth') document.getElementById('ethAddressField').style.display = 'block';
        if (this.value === 'usdt') document.getElementById('usdtAddressField').style.display = 'block';
    });

    // Copy address function
    function copyAddress(id) {
        const input = document.getElementById(id);
        input.select();
        input.setSelectionRange(0, 99999);
        navigator.clipboard.writeText(input.value);
        const original = input.value;
        input.value = 'Copied!';
        setTimeout(() => { input.value = original; }, 1500);
    }
</script>