<?php 
include "./header.php";

// Get user details
$currentUser = getUserDetails('users', $conn);
$userName = $currentUser['fullname'] ?? '';
$userEmail = $currentUser['email'] ?? '';

if (isset($_GET['message'])): ?>
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script>
    Swal.fire({
      icon: '<?= isset($_GET['error']) ? 'error' : 'success' ?>',
      title: '<?= htmlspecialchars($_GET['message']) ?>',
      showConfirmButton: false,
      timer: 2000
    });
  </script>
<?php endif; ?>

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

body {
    background: linear-gradient(135deg, #2664eb, #1e40af);
    min-height: 100vh;
    padding: 2rem;
}

.support-container {
    max-width: 1200px;
    margin: 0 auto;
}

.page-header {
    text-align: center;
    color: white;
    margin-bottom: 2rem;
}

.page-header h1 {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.page-header p {
    font-size: 1rem;
    opacity: 0.9;
}

.support-layout {
    display: grid;
    grid-template-columns: 300px 1fr;
    gap: 2rem;
}

.sidebar {
    background: white;
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    overflow: hidden;
    height: fit-content;
}

.sidebar-header {
    background: linear-gradient(135deg, #2664eb, #1e40af);
    color: white;
    padding: 1.5rem;
    text-align: center;
}

.sidebar-header h4 {
    font-size: 1.1rem;
    font-weight: 600;
    margin: 0;
}

.sidebar-body {
    padding: 1.5rem;
}

.quick-action-btn {
    display: block;
    width: 100%;
    padding: 0.9rem;
    background: linear-gradient(135deg, #2664eb, #1e40af);
    color: white;
    border: none;
    border-radius: 6px;
    font-size: 1rem;
    font-weight: 600;
    cursor: pointer;
    margin-bottom: 1.5rem;
    transition: all 0.3s;
}

.quick-action-btn:hover {
    background: linear-gradient(135deg, #1e40af, #2664eb);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(38, 100, 235, 0.3);
}

.sidebar-section {
    margin-bottom: 1.5rem;
}

.sidebar-section h5 {
    font-size: 0.9rem;
    font-weight: 600;
    color: #64748b;
    text-transform: uppercase;
    margin-bottom: 0.75rem;
    padding-bottom: 0.5rem;
    border-bottom: 2px solid #e2e8f0;
}

.sidebar-section ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.sidebar-section li {
    margin-bottom: 0.5rem;
}

.sidebar-section a {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem;
    color: #334155;
    text-decoration: none;
    border-radius: 6px;
    transition: all 0.2s;
}

.sidebar-section a:hover {
    background: #f1f5f9;
    color: #2664eb;
}

.sidebar-section i {
    font-size: 1.2rem;
    width: 20px;
    text-align: center;
}

.main-card {
    background: white;
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    overflow: hidden;
}

.card-header {
    background: linear-gradient(135deg, #2664eb, #1e40af);
    color: white;
    padding: 1.5rem;
}

.card-header h4 {
    font-size: 1.5rem;
    font-weight: 600;
    margin: 0 0 0.5rem 0;
}

.card-header p {
    margin: 0;
    opacity: 0.9;
    font-size: 0.95rem;
}

.card-body {
    padding: 2rem;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 500;
    color: #333;
}

.form-control, select, textarea {
    width: 100%;
    padding: 0.75rem 1rem;
    border: 1px solid #ddd;
    border-radius: 6px;
    font-size: 1rem;
    transition: border-color 0.3s;
    font-family: inherit;
}

.form-control:focus, select:focus, textarea:focus {
    outline: none;
    border-color: #2664eb;
    box-shadow: 0 0 0 3px rgba(38, 100, 235, 0.2);
}

textarea {
    resize: vertical;
    min-height: 150px;
}

.btn-primary {
    display: inline-block;
    padding: 0.9rem 2rem;
    background: linear-gradient(135deg, #2664eb, #1e40af);
    color: white;
    border: none;
    border-radius: 6px;
    font-size: 1.1rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #1e40af, #2664eb);
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(38, 100, 235, 0.3);
}

.info-box {
    background: #eff6ff;
    border-left: 4px solid #2664eb;
    padding: 1rem;
    border-radius: 6px;
    margin-top: 1.5rem;
}

.info-box h5 {
    font-size: 1rem;
    font-weight: 600;
    color: #1e40af;
    margin: 0 0 0.5rem 0;
}

.info-box p {
    margin: 0;
    color: #1e40af;
    font-size: 0.9rem;
}

.info-box a {
    color: #2664eb;
    font-weight: 600;
    text-decoration: none;
}

.email-display {
    background: #f8fafc;
    padding: 0.75rem 1rem;
    border-radius: 6px;
    border: 1px solid #e2e8f0;
    margin-top: 0.5rem;
    font-family: 'Courier New', monospace;
    color: #2664eb;
    font-weight: 600;
}

@media (max-width: 968px) {
    .support-layout {
        grid-template-columns: 1fr;
    }
    
    body {
        padding: 1rem;
    }
}
</style>

<body>
<div class="support-container">
    <div class="page-header">
        <h1>🎧 Support Center</h1>
        <p>We're here to help you 24/7</p>
    </div>

    <div class="support-layout">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="sidebar-header">
                <h4>Quick Actions</h4>
            </div>
            <div class="sidebar-body">
                <button type="button" class="quick-action-btn" onclick="document.getElementById('ticketForm').scrollIntoView({behavior: 'smooth'})">
                    NEW TICKET
                </button>

                <div class="sidebar-section">
                    <h5>Help Topics</h5>
                    <ul>
                        <li><a href="#"><i class="fas fa-history"></i> My Tickets</a></li>
                        <li><a href="#"><i class="fas fa-clock"></i> Pending Issues</a></li>
                        <li><a href="#"><i class="fas fa-check-circle"></i> Resolved Tickets</a></li>
                    </ul>
                </div>

                <div class="sidebar-section">
                    <h5>Support Categories</h5>
                    <ul>
                        <li><a href="#"><i class="fas fa-wallet" style="color: #22c55e;"></i> Deposit Issues</a></li>
                        <li><a href="#"><i class="fas fa-money-bill-wave" style="color: #ef4444;"></i> Withdrawal Problems</a></li>
                        <li><a href="#"><i class="fas fa-user-circle" style="color: #f59e0b;"></i> Account Verification</a></li>
                        <li><a href="#"><i class="fas fa-shield-alt" style="color: #8b5cf6;"></i> Security Concerns</a></li>
                        <li><a href="#"><i class="fas fa-chart-line" style="color: #06b6d4;"></i> Trading Questions</a></li>
                        <li><a href="#"><i class="fas fa-question-circle" style="color: #64748b;"></i> General Inquiry</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="main-card">
            <div class="card-header">
                <h4>📨 Submit a Support Ticket</h4>
                <p>Our team typically responds within 24 hours</p>
            </div>

            <form class="card-body" method="post" action="./scripts/support_process.php" id="ticketForm">
                <div class="form-group">
                    <label>Full Name</label>
                    <input type="text" 
                           class="form-control" 
                           name="name" 
                           value="<?= htmlspecialchars($userName) ?>" 
                           required 
                           readonly>
                </div>

                <div class="form-group">
                    <label>Email Address</label>
                    <input type="email" 
                           class="form-control" 
                           name="email" 
                           value="<?= htmlspecialchars($userEmail) ?>" 
                           required 
                           readonly>
                </div>

                <div class="form-group">
                    <label>Select Issue Category</label>
                    <select name="category" class="form-control" id="categorySelect" required>
                        <option value="">-- Choose Category --</option>
                        <option value="deposits">Deposit Issues</option>
                        <option value="withdrawals">Withdrawal Problems</option>
                        <option value="verification">Account Verification</option>
                        <option value="security">Security Concerns</option>
                        <option value="trading">Trading Questions</option>
                        <option value="technical">Technical Support</option>
                        <option value="general">General Inquiry</option>
                    </select>
                    <div id="emailDisplay"></div>
                </div>

                <div class="form-group">
                    <label>Subject</label>
                    <input type="text" 
                           class="form-control" 
                           name="subject" 
                           placeholder="Brief description of your issue"
                           required>
                </div>

                <div class="form-group">
                    <label>Priority Level</label>
                    <select name="priority" class="form-control" required>
                        <option value="">-- Select Priority --</option>
                        <option value="low">Low - General Question</option>
                        <option value="medium">Medium - Need Assistance</option>
                        <option value="high">High - Urgent Issue</option>
                        <option value="critical">Critical - Account/Fund Issue</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Message</label>
                    <textarea class="form-control" 
                              name="message" 
                              placeholder="Please provide as much detail as possible about your issue..."
                              required></textarea>
                </div>

                <div class="form-group">
                    <label>Attachment (Optional)</label>
                    <input type="file" 
                           class="form-control" 
                           name="attachment"
                           accept=".jpg,.jpeg,.png,.pdf,.doc,.docx">
                    <small style="color: #6b7280; font-size: 0.85rem; margin-top: 0.25rem; display: block;">
                        Supported formats: JPG, PNG, PDF, DOC (Max 5MB)
                    </small>
                </div>

                <button type="submit" name="submit_ticket" class="btn-primary">
                    <i class="fas fa-paper-plane"></i> Submit Ticket
                </button>

                <div class="info-box">
                    <h5>📞 Alternative Contact Methods</h5>
                    <p>
                        Prefer direct contact? Email us at <a href="mailto:support@pinnexhub.com">support@pinnexhub.com</a><br>
                        Or call our 24/7 hotline: <strong>+1 (555) 123-4567</strong>
                    </p>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// Email routing based on category
const categoryEmails = {
    'deposits': 'deposits@pinnexhub.com',
    'withdrawals': 'withdrawals@pinnexhub.com',
    'verification': 'verification@pinnexhub.com',
    'security': 'security@pinnexhub.com',
    'trading': 'trading@pinnexhub.com',
    'technical': 'technical@pinnexhub.com',
    'general': 'support@pinnexhub.com'
};

const categorySelect = document.getElementById('categorySelect');
const emailDisplay = document.getElementById('emailDisplay');

categorySelect.addEventListener('change', function() {
    const category = this.value;
    if (category && categoryEmails[category]) {
        emailDisplay.innerHTML = `
            <small style="color: #64748b; font-size: 0.85rem; margin-top: 0.5rem; display: block;">
                Your ticket will be sent to:
            </small>
            <div class="email-display">
                <i class="fas fa-envelope"></i> ${categoryEmails[category]}
            </div>
        `;
    } else {
        emailDisplay.innerHTML = '';
    }
});

// Form submission
document.getElementById('ticketForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const category = categorySelect.value;
    const subject = this.querySelector('input[name="subject"]').value;
    const priority = this.querySelector('select[name="priority"]').value;
    
    if (!category) {
        Swal.fire({
            icon: 'error',
            title: 'Missing Category',
            text: 'Please select an issue category'
        });
        return;
    }
    
    if (!priority) {
        Swal.fire({
            icon: 'error',
            title: 'Missing Priority',
            text: 'Please select a priority level'
        });
        return;
    }
    
    Swal.fire({
        title: 'Submit Support Ticket?',
        html: `
            <div style="text-align: left;">
                <p><strong>Category:</strong> ${category}</p>
                <p><strong>Subject:</strong> ${subject}</p>
                <p><strong>Will be sent to:</strong> ${categoryEmails[category]}</p>
            </div>
        `,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#2664eb',
        cancelButtonColor: '#ef4444',
        confirmButtonText: 'Yes, Submit',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            // In a real implementation, this would submit to your backend
            Swal.fire({
                icon: 'success',
                title: 'Ticket Submitted!',
                html: `Your ticket has been sent to <strong>${categoryEmails[category]}</strong><br>We'll respond within 24 hours.`,
                confirmButtonColor: '#2664eb'
            }).then(() => {
                this.reset();
                emailDisplay.innerHTML = '';
            });
        }
    });
});
</script>
</body>
</html>