<?php
include "./header.php";
?>

<!-- Main Content -->
<div class="main-content">
  <section class="section">
    <div class="section-body">
      <div class="row">

        <!-- Deposit Transactions -->
        <div class="col-12 col-md-6 col-lg-12">
          <div class="card border-0 shadow-sm">
            <div class="card-header border-0 bg-white">
              <h4 class="mb-0 text-dark">Deposit Transactions</h4>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-striped align-middle">
                  <thead>
                    <tr class="text-secondary">
                      <th>S/N</th>
                      <th>Coin</th>
                      <th>Amount</th>
                      <th>Status</th>
                      <th>Date</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    $id = $_SESSION['id'];
                    $sql = "SELECT * FROM `deposits` WHERE `registration_id` = '$id'";
                    $result = $conn->query($sql);
                    $count = 1;

                    if ($result !== false && $result->num_rows > 0) {
                      while ($row = mysqli_fetch_array($result)) { ?>
                        <tr>
                          <td><?= $count ?></td>
                          <td class="fw-semibold text-dark"><?= $row['coin'] ?></td>
                          <td class="fw-semibold text-dark"><?= $row['amount'] ?></td>
                          <td>
                            <?php 
                              $statusColor = 'linear-gradient(to right, #2664eb, #1e40af)';
                            ?>
                            <span class="badge rounded-pill px-3 py-2" style="background: <?= $statusColor ?>; color:#fff;">
                              <?= ucfirst($row['status']) ?>
                            </span>
                          </td>
                          <td class="text-muted"><?= date("d M Y", strtotime($row['date'])) ?></td>
                        </tr>
                      <?php
                        $count++;
                      }
                    } else { ?>
                      <tr>
                        <td colspan="5" class="text-center text-muted py-3">No Deposit Transactions Available</td>
                      </tr>
                    <?php } ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>

        <!-- Withdrawal Transactions -->
        <div class="col-12 col-md-6 col-lg-12">
          <div class="card border-0 shadow-sm mt-4">
            <div class="card-header border-0 bg-white">
              <h4 class="mb-0 text-dark">Withdrawal Transactions</h4>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table class="table table-striped align-middle">
                  <thead>
                    <tr class="text-secondary">
                      <th>S/N</th>
                      <th>Coin</th>
                      <th>Amount</th>
                      <th>Account</th>
                      <th>Status</th>
                      <th>Date</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    $id = $_SESSION['id'];
                    $sql = "SELECT * FROM `withdrawals` WHERE `registration_id` = '$id'";
                    $result = $conn->query($sql);
                    $count = 1;

                    if ($result !== false && $result->num_rows > 0) {
                      while ($row = mysqli_fetch_array($result)) { ?>
                        <tr>
                          <td><?= $count ?></td>
                          <td class="fw-semibold text-dark"><?= $row['coin'] ?></td>
                          <td class="fw-semibold text-dark"><?= $row['amount'] ?></td>
                          <td style="text-transform: capitalize;"><?= $row['account'] ?></td>
                          <td>
                            <?php 
                              $statusColor = 'linear-gradient(to right, #2664eb, #1e40af)'; 
                            ?>
                            <span class="badge rounded-pill px-3 py-2" style="background: <?= $statusColor ?>; color:#fff;">
                              <?= ucfirst($row['status']) ?>
                            </span>
                          </td>
                          <td class="text-muted"><?= date("d M Y", strtotime($row['date'])) ?></td>
                        </tr>
                      <?php
                        $count++;
                      }
                    } else { ?>
                      <tr>
                        <td colspan="6" class="text-center text-muted py-3">No Withdrawal Transactions Available</td>
                      </tr>
                    <?php } ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </section>
</div>