<?php

// sanitize inputs
function sanitize($input)
{
    global $connection;
    return mysqli_real_escape_string($connection, htmlspecialchars(trim($input)));
}

// redirect page
function redirect($url)
{
    return header("Location: $url");
}

// alert
function set_alert($message, $type = "success")
{
    $_SESSION['ALERT'] = json_encode([
        "message" => $message,
        "type" => $type
    ]);
}

// upload files
function upload_file($medias, $destination, $MAX_SIZE_LIMIT = 20)
{
    // print_r($medias);
    // exit;
    // Check error
    if ($medias['error']) throw new AppException("Error uploading file");

    // Check filesize
    $MAX_SIZE = $MAX_SIZE_LIMIT * 1024 * 1024; // 20mb
    if ($medias['size'] > $MAX_SIZE) throw new AppException("File too large");

    // File
    $name = $medias['name'];

    // Rename file
    $timestamp = time();
    $name = $timestamp . $name;

    // Upload the file
    $temp_location = $medias['tmp_name'];

    if (move_uploaded_file($temp_location, $destination . $name)) return $name;
    return false;
}

// make query
function makeQuery($sql)
{
    global $connection;
    return mysqli_query($connection, $sql);
}

// update investment status
// y
