<?php

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require_once("../config/db.php");
require_once("../utils/functions.php");
require_once "../utils/errors.php";
require_once "../store/transact.php";
require_once "../store/admin.php";

require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';
require_once 'PHPMailer/src/Exception.php';

if (!$_SESSION['ADMIN']) redirect("../login");


function refer_bonus($ref_code, $amount):bool{
    global $connection;
    $sql = "UPDATE users SET bonus = bonus + $amount, balance = balance + $amount WHERE referral_code = '$ref_code'";
    $res = mysqli_query($connection,$sql);
    return $res;
}

// Initialize PHPMailer
$mail = new PHPMailer();

$mail->SMTPDebug = 0;
// $mail->SMTPDebug = SMTP::DEBUG_SERVER;
// $mail->isSMTP();
$mail->Host = 'smtp.titan.email';
$mail->SMTPAuth = true;
$mail->Username = 'support@optimustradeince.com';
$mail->Password = 'bbdsgceackfkcqzh';
$mail->SMTPSecure = 'ssl';
$mail->Port = 465;
// bbdsgceackfkcqzh


$mail->setFrom('support@optimustradeince.com', 'Optimus Inc');

// deposit
if (isset($_POST['deposit'])) 
{
    // deposit transaction variables
    $transaction_id = $_POST['trn_id'];
    $account = $_POST['account'];
    $package = $_POST['plan'];
    $user = get_user_id($_POST['usr_id']);
    // var_dump($_POST);
    // exit;
    $user_id = $user['registration_id'];
    $ref_code = $user['referee_code'];
    $amount = floatval($_POST['amount']);
    $formattedAmount = number_format($amount);
    // var_dump($_POST);
    // exit;
    
    // Add recipient
    $mail->addAddress($user['email'], 'user');

    try 
    {
        
        // when plan should end 
        $currentTimestamp = time();
        $now = date('Y-m-d H:i:s', $currentTimestamp);
        $formattedDateTime = date('Y-m-d H:i:s', $currentTimestamp);
        
        // Define an associative array to map plans to hours
        $planHoursMap = [
            'standard' => 24,
            'bronze'   => 48,
            'silver'   => 72,
            'gold'     => 96,
        ];
        
        // Check if the selected plan exists in the map
        if (isset($planHoursMap[$package])) {
            // Add the corresponding hours to the current timestamp
            $dueDateTimestamp = strtotime("$formattedDateTime + {$planHoursMap[$package]} hours");
        
            // Format the new timestamp into a human-readable date and time
            $dueDate = date('Y-m-d H:i:s', $dueDateTimestamp);
        }

        // Start a transaction
        mysqli_autocommit($connection, false);

        // update user balance or shares balance
        if ($account === 'savings') {
            $old_balance = $user['balance'];
            $new_balance = $old_balance + $amount;
            $query_user = "UPDATE `users` SET `balance`= $new_balance, `package`='$package' WHERE `registration_id`='$user_id'";
        } elseif ($account === 'investment') { 
            $old_shares = $user['shares'];
            $new_shares = $old_shares + $amount;
            $query_user = "UPDATE `users` SET `shares`= $new_shares, `package`='$package' WHERE `registration_id`='$user_id'";
        }

        $res_user = mysqli_query($connection, $query_user);

        $sql = "UPDATE shares SET status = 'active', `created_at` = '$now', `updated_at` = '$dueDate' WHERE transaction_id = '$transaction_id'";
        $res = mysqli_query($connection, $sql);

        // Check for errors in database update and email sending
        if (!$res & !$res_user) {
            throw new AppException("Failed to update user or shares information");
        }
        
        // Commit the transaction
        mysqli_commit($connection);
        
        // Construct email content
         $mail->isHTML(true); 
        $mail->Subject = 'Deposit Approved';
        $mail->Body = "<p>Dear {$user['fullname']},</p>

                <p>We are pleased to inform you that your deposit of $$formattedAmount in $coin has been successfully approved. You are now ready to start investing with Optimus Inc.</p>
            
                <p>Here are some key details:</p>
            
                <ul>
                    <li>Deposit Amount: $$formattedAmount</li>
                    <li>Coin: $coin</li>
                </ul>
            
                <p>You can proceed to invest and explore the various investment plans we offer.</p>
            
                <p>Thank you for choosing Optimus Inc. We look forward to assisting you on your investment journey.</p>
            
                <p>Best regards,<br>Management, Optimus Inc.</p>";
    
        // Update the status in the 'deposits' table
        $query = "UPDATE `deposits` SET `status` = 'approved', `amount` = '$amount' WHERE `transaction_id` = '$transaction_id' ";
        $res_deposit = mysqli_query($connection, $query);

        // Refer bonus
        refer_bonus($ref_code, 0.7 * $amount);

        if(!$res_deposit || !$mail->send()) throw new AppException("Failed to update deposit status or send email");
        set_alert("Deposit successful");
        redirect("basic-table");
    } 
    catch (AppException $e) 
    {
        // Rollback the transaction in case of an error
        mysqli_rollback($connection);
        
        set_alert($e->message, $e->type);
        redirect("basic-table");
    }
}

// withdrawal
if(isset($_POST['withdrawal']))
{
    
    $transaction_id = $_POST['trn_id'];
    $account = $_POST['account'];
    // die($account);
    $user = get_user_id($_POST['usr_id']);
    $user_id = $user['registration_id'];
    $ref_code = $user['referee_code'];
    $amount = floatval($_POST['amount']);
    $formattedAmount = number_format($amount);
    // var_dump($_POST);
    // exit;
    
    try 
    {
        // $t_withdrawal = intval($user['t_withdrawal']) + $amount;
        // Add recipient
        $mail->addAddress($user['email'], 'user');
        

        // update user balance / shares balance
        if($account == 'savings') {
            // die("here1");
            $old_balance = $user['balance'];
            $new_balance = $old_balance - $amount;
            $query_user = "UPDATE `users` SET `balance`= $new_balance  WHERE `registration_id`='$user_id'";
            $res_user = mysqli_query($connection, $query_user);

        }
        // update shares balance
        if($account == 'investment') { 
            // die("here2");
            $old_shares = $user['shares'];
            $new_shares = $old_shares - $amount;
            $query_user = "UPDATE `users` SET `shares`= $new_shares WHERE `registration_id`='$user_id'";
            $res_user = mysqli_query($connection, $query_user);

        }
        
        // Construct email content
         $mail->isHTML(true); 
        $mail->Subject = 'Withdrawal Approved';
        $mail->Body = "Dear {$user['fullname']},<br><br>
            We are pleased to confirm that your withdrawal request has been successfully approved. The requested amount has been processed and will be sent to your designated account shortly.<br><br>
            Here are the details of your withdrawal:<br><br>
            - Withdrawal Amount: $$formattedAmount<br>
            - Transaction ID: $transaction_id<br><br>
            If you have any questions or concerns, please feel free to contact our support team.<br><br>
            Thank you for choosing Optimus Inc. We appreciate your trust in our services.<br><br>
            Best regards,<br>
            Management, Optimus Inc.";
    
        $query = "UPDATE `withdrawals` SET `status` = 'approved', `amount` = '$amount' WHERE `transaction_id` = '$transaction_id' ";
        $res = mysqli_query($connection, $query);

        if(!$res || !$res_user || !$mail->send()){
            // Log the database error message
            error_log("Database error: " . mysqli_error($connection));
            // Display an error message to the user
            set_alert("An error occurred. Please try again later.", "error");
            redirect("basic-table");
        }
        
        // throw new AppException("An Error occured");
        // if (!$mail->send()) {
        //     throw new AppException("Email sending failed: " . $mail->ErrorInfo);
        // }
        set_alert("Withdrawal successful");
        redirect("basic-table");

    } 
    catch (AppException $e) 
    {
        // Rollback the transaction in case of an error
        mysqli_rollback($connection);
        
        // Log the detailed error message
        error_log("Error: " . $e->getMessage());
        
        set_alert($e->message, $e->type);
        redirect("basic-table");
    }
}





