<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once("../config/db.php");
require_once("../utils/functions.php");
require_once "../store/transact.php";
require_once "../store/admin.php";
// require_once "../handlers/user_handler.php";

if (!$_SESSION['ADMIN']) redirect("../login");

$DEPOSITS = get_user_deposits();
$WITHDRAW = get_user_withdrawal();
$SHARES = get_all_shares();
// foreach ($SHARES as $shares) {
//   updateShareStatus($shares['transaction_id']);
// }
// exit;

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title> Admin Dashboard</title>
  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="../css/bootstrap.min.css">
  <!-- Typography CSS -->
  <link rel="stylesheet" href="../css/typography.css">
  <!-- Responsive CSS -->
  <link rel="stylesheet" href="../css/responsive.css">
  <!-- plugins:css -->
  <link rel="stylesheet" href="../assets/vendors/mdi/css/materialdesignicons.min.css">
  <link rel="stylesheet" href="../assets/vendors/css/vendor.bundle.base.css">
  <!-- endinject -->
  <!-- Plugin css for this page -->
  <!-- End plugin css for this page -->
  <!-- DataTables -->
  <link rel="stylesheet" href="../plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="../plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="../plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Layout styles -->
  <link rel="stylesheet" href="../assets/css/style.css">
  <!-- End layout styles -->
  <link rel="shortcut icon" href="../assets/images/favicon.png" />
</head>

<body>
  <?php include_once "../includes/alert.php"; ?>
  <div class="container-scroller">
    <!-- partial:../partials/_sidebar.html -->
    <nav class="sidebar sidebar-offcanvas" id="sidebar">
      <div class="sidebar-brand-wrapper d-none d-lg-flex align-items-center justify-content-center fixed-top">
        <a class="sidebar-brand brand-logo" href="../index.html"><img src="../assets/images/logo.svg" alt="logo" /></a>
        <a class="sidebar-brand brand-logo-mini" href="../index.html"><img src="../assets/images/logo-mini.svg" alt="logo" /></a>
      </div>
      <ul class="nav">
        <li class="nav-item profile">
          <div class="profile-desc">
            <div class="profile-pic">
              <div class="count-indicator">
                <img class="img-xs rounded-circle " src="../assets/images/faces/face15.jpg" alt="">
                <span class="count bg-success"></span>
              </div>
              <div class="profile-name">
                <h5 class="mb-0 font-weight-normal">Henry Klein</h5>
                <span>Gold Member</span>
              </div>
            </div>
            <a href="#" id="profile-dropdown" data-toggle="dropdown"><i class="mdi mdi-dots-vertical"></i></a>
            <div class="dropdown-menu dropdown-menu-right sidebar-dropdown preview-list" aria-labelledby="profile-dropdown">
              <a href="#" class="dropdown-item preview-item">
                <div class="preview-thumbnail">
                  <div class="preview-icon bg-dark rounded-circle">
                    <i class="mdi mdi-settings text-primary"></i>
                  </div>
                </div>
                <div class="preview-item-content">
                  <p class="preview-subject ellipsis mb-1 text-small">Account settings</p>
                </div>
              </a>
              <div class="dropdown-divider"></div>
              <a href="#" class="dropdown-item preview-item">
                <div class="preview-thumbnail">
                  <div class="preview-icon bg-dark rounded-circle">
                    <i class="mdi mdi-onepassword  text-info"></i>
                  </div>
                </div>
                <div class="preview-item-content">
                  <p class="preview-subject ellipsis mb-1 text-small">Change Password</p>
                </div>
              </a>
              <div class="dropdown-divider"></div>
              <a href="#" class="dropdown-item preview-item">
                <div class="preview-thumbnail">
                  <div class="preview-icon bg-dark rounded-circle">
                    <i class="mdi mdi-calendar-today text-success"></i>
                  </div>
                </div>
                <div class="preview-item-content">
                  <p class="preview-subject ellipsis mb-1 text-small">To-do list</p>
                </div>
              </a>
            </div>
          </div>
        </li>
        <li class="nav-item nav-category">
          <span class="nav-link">Navigation</span>
        </li>
        <li class="nav-item menu-items">
          <a class="nav-link" href="../index.php">
            <span class="menu-icon">
              <i class="mdi mdi-speedometer"></i>
            </span>
            <span class="menu-title">Dashboard</span>
          </a>
        </li>

        <li class="nav-item menu-items">
          <a class="nav-link" href="../pages/basic_elements.php">
            <span class="menu-icon">
              <i class="mdi mdi-playlist-play"></i>
            </span>
            <span class="menu-title">Edit wallet</span>
          </a>
        </li>
        <li class="nav-item menu-items">
          <a class="nav-link" href="../pages/basic-table.php">
            <span class="menu-icon">
              <i class="mdi mdi-table-large"></i>
            </span>
            <span class="menu-title">Deposit & Withdrawal</span>
          </a>
        </li>

      </ul>
    </nav>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:../partials/_navbar.php -->
      <nav class="navbar p-0 fixed-top d-flex flex-row">
        <div class="navbar-brand-wrapper d-flex d-lg-none align-items-center justify-content-center">
          <a class="navbar-brand brand-logo-mini" href="../index.php"><img src="../assets/images/logo-mini.svg" alt="logo" /></a>
        </div>
        <div class="navbar-menu-wrapper flex-grow d-flex align-items-stretch">
          <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
            <span class="mdi mdi-menu"></span>
          </button>
          <ul class="navbar-nav w-100">
            <li class="nav-item w-100">
              <form class="nav-link mt-2 mt-md-0 d-none d-lg-flex search">
                <input type="text" class="form-control" placeholder="Search products">
              </form>
            </li>
          </ul>
          <ul class="navbar-nav navbar-nav-right">
            <li class="nav-item dropdown d-none d-lg-block">
              <a class="nav-link btn btn-success create-new-button" id="createbuttonDropdown" data-toggle="dropdown" aria-expanded="false" href="#">+ Create New Project</a>
              <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="createbuttonDropdown">
                <h6 class="p-3 mb-0">Projects</h6>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-file-outline text-primary"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject ellipsis mb-1">Software Development</p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-web text-info"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject ellipsis mb-1">UI Development</p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-layers text-danger"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject ellipsis mb-1">Software Testing</p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <p class="p-3 mb-0 text-center">See all projects</p>
              </div>
            </li>
            <li class="nav-item nav-settings d-none d-lg-block">
              <a class="nav-link" href="#">
                <i class="mdi mdi-view-grid"></i>
              </a>
            </li>
            <li class="nav-item dropdown border-left">
              <a class="nav-link count-indicator dropdown-toggle" id="messageDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
                <i class="mdi mdi-email"></i>
                <span class="count bg-success"></span>
              </a>

            </li>
            <li class="nav-item dropdown border-left">
              <a class="nav-link count-indicator dropdown-toggle" id="notificationDropdown" href="#" data-toggle="dropdown">
                <i class="mdi mdi-bell"></i>
                <span class="count bg-danger"></span>
              </a>
              <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
                <h6 class="p-3 mb-0">Notifications</h6>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-calendar text-success"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject mb-1">Event today</p>
                    <p class="text-muted ellipsis mb-0"> Just a reminder that you have an event today </p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-settings text-danger"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject mb-1">Settings</p>
                    <p class="text-muted ellipsis mb-0"> Update dashboard </p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-link-variant text-warning"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject mb-1">Launch Admin</p>
                    <p class="text-muted ellipsis mb-0"> New admin wow! </p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <p class="p-3 mb-0 text-center">See all notifications</p>
              </div>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link" id="profileDropdown" href="#" data-toggle="dropdown">
                <div class="navbar-profile">
                  <img class="img-xs rounded-circle" src="../assets/images/faces/face15.jpg" alt="">
                  <p class="mb-0 d-none d-sm-block navbar-profile-name">Henry Klein</p>
                  <i class="mdi mdi-menu-down d-none d-sm-block"></i>
                </div>
              </a>
              <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="profileDropdown">
                <h6 class="p-3 mb-0">Profile</h6>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-settings text-success"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject mb-1">Settings</p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-logout text-danger"></i>
                    </div>
                  </div>
                  <form class="preview-item-content" action="../handlers/auth_handler.php" method="post">
                    <button type="submit" name="logout" style="background: transparent; outline:none; border:none; color:white;" class="preview-subject mb-1">Logout</button>
                  </form>
                </a>
                <div class="dropdown-divider"></div>
                <p class="p-3 mb-0 text-center">Advanced settings</p>
              </div>
            </li>
          </ul>
          <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
            <span class="mdi mdi-format-line-spacing"></span>
          </button>
        </div>
      </nav>
      <!-- partial -->
      <div class="main-panel">

        <div class="content-wrapper">
          <div class="page-header">
            <h3 class="page-title"> Transaction Tables </h3>
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <!-- <li class="breadcrumb-item"><a href="#">Tables</a></li> -->
                <!-- <li class="breadcrumb-item active" aria-current="page">Basic tables</li> -->
              </ol>
            </nav>
          </div>
          <div class="row">

            <!-- deposits -->
            <div class="col-12 grid-margin">
              <div class="card">
                <div class="card-header">
                  <h4 class="card-title">Pending Deposit</h4>
                  <p class="card-description"> Approve or<code>Decline</code>
                  </p>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <?php if ($DEPOSITS) : ?>
                    <table id="example1" class="table">
                      <thead>
                        <tr>
                          <th>User Name</th>
                          <th>Transaction ID</th>
                          <th>Account</th>
                          <th>Coin</th>
                          <th>Plan</th>
                          <th>Amount</th>
                          <th>Action</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php foreach ($DEPOSITS as $deposit) : ?>
                          <?php $user = get_user_id($deposit['registration_id']) ?>
                          <tr>
                            <td><?= $user['fullname'] ?></td>
                            <td><?= $deposit['transaction_id'] ?></td>
                            <td><?= $deposit['account'] ?></td>
                            <td><?= $deposit['coin'] ?></td>
                            <td><?= $deposit['package'] ?></td>
                            <td class="text-success">$<?= $deposit['amount'] ?> <i class="mdi mdi-arrow-up"></i></td>
                            <td class="table2">
                              <a href="accept.php?transaction_id=<?= $deposit['transaction_id'] ?>&user_id=<?= $deposit['registration_id'] ?>&amount=<?= $deposit['amount'] ?>&type=deposit&account=<?= $deposit['account'] ?>&package=<?= $deposit['package'] ?>&coin=<?= $deposit['coin'] ?>" class="badge badge-success">
                                <span>Approve</span>
                              </a>
                              <a href="decline.php?transaction_id=<?= $deposit['transaction_id'] ?>&user_id=<?= $deposit['registration_id'] ?>&amount=<?= $deposit['amount'] ?>&type=deposit&account=<?= $deposit['account'] ?>&package=<?= $deposit['package'] ?>&coin=<?= $deposit['coin'] ?>" class="badge badge-danger">
                                <span>Decline</span>
                              </a>
                              <!--<a href="edit-depo.php?transaction_id=<?= $deposit['transaction_id'] ?>&user_id=<?= $deposit['registration_id'] ?>&amount=<?= $deposit['amount'] ?>&type=deposit&account=<?= $deposit['account'] ?>&package=<?= $deposit['package'] ?>" class="badge badge-info">-->
                              <!--  <span>Edit</span>-->
                              <!--</a>-->
                            </td>
                          </tr>
                        <?php endforeach; ?>
                      </tbody>
                    </table>
                  <?php else : ?>
                    <p>No transaction available</p>
                  <?php endif; ?>
                </div>
                <!-- /.card-body -->
              </div>
              <!-- /.card -->
            </div>

            <!-- withdrawals -->
            <div class="col-12 grid-margin">
              <div class="card">
                <div class="card-header">
                  <h4 class="card-title">Pending withdrawal</h4>
                  <p class="card-description"> Approve or<code>Decline</code>
                  </p>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <?php if ($WITHDRAW) : ?>
                    <table id="example3" class="table">
                      <thead>
                        <th>User Name</th>
                        <th>Wallet Address</th>
                        <th>Account</th>
                        <th>Coin</th>
                        <th>Network</th>
                        <th>Amount</th>
                        <th>Action</th>
                      </thead>
                      <tbody>
                        <?php foreach ($WITHDRAW as $withdraw) : ?>
                          <?php $user = get_user_id($withdraw['registration_id']) ?>
                          <tr>
                            <td><?= $user['fullname'] ?></td>
                            <td><?= $withdraw['walletAddress'] ?></td>
                            <td><?= $withdraw['account'] ?></td>
                            <td><?= $withdraw['coin'] ?></td>
                            <td><?= $withdraw['network'] ?></td>
                            <td class="text-danger">$<?= $withdraw['amount'] ?> <i class="mdi mdi-arrow-down"></i></td>
                            <td class="table2">
                              <a href="accept.php?transaction_id=<?= $withdraw['id'] ?>&user_id=<?= $withdraw['registration_id'] ?>&amount=<?= $withdraw['amount'] ?>&type=withdrawal&account=<?= $withdraw['account'] ?>" class="badge badge-success">
                                <span>Approve</span>
                              </a>
                              <a href="decline.php?transaction_id=<?= $withdraw['id'] ?>&user_id=<?= $withdraw['registration_id'] ?>&amount=<?= $withdraw['amount'] ?>&type=withdrawal&account=<?= $withdraw['account'] ?>" class="badge badge-danger">
                                <span>Decline</span>
                              </a>
                              <!--<a href="edit-with.php?transaction_id=<?= $withdraw['id'] ?>&user_id=<?= $withdraw['registration_id'] ?>&amount=<?= $withdraw['amount'] ?>&type=withdrawal&account=<?= $withdraw['account'] ?>" class="badge badge-info">-->
                              <!--  <span>Edit</span>-->
                              <!--</a>-->
                            </td>
                          </tr>
                        <?php endforeach; ?>
                      </tbody>
                    </table>
                  <?php else : ?>
                    <p>No transaction available</p>
                  <?php endif; ?>
                </div>
                <!-- /.card-body -->
              </div>
              <!-- /.card -->
            </div>

            <!-- settled deposits -->
            <div class="col-12 grid-margin">
              <div class="card">
                <div class="card-header">
                  <h4 class="card-title">Settled Deposits</h4>
                  <?php $PROCESSED_DEPOSITS = get_processed_deposits(); ?>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <?php if ($PROCESSED_DEPOSITS) : ?>
                    <table id="example4" class="table">
                      <thead>
                        <tr>
                          <th> Name </th>
                          <th> User ID </th>
                          <th> Account </th>
                          <th> Plan </th>
                          <th> Amount </th>
                          <th> Date </th>
                          <th> Status </th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php foreach ($PROCESSED_DEPOSITS as $pr_deposit) : ?>
                          <?php $user = get_user_id($pr_deposit['registration_id']) ?>
                          <tr>
                            <td> <?= $user['fullname'] ?? "Account Deleted" ?> </td>
                            <td> <?= $pr_deposit['registration_id'] ?> </td>
                            <td> <?= $pr_deposit['coin'] ?> </td>
                            <td> <?= $user['package'] ?? "Account Deleted" ?> </td>
                            <td> <?= $pr_deposit['amount'] ?> </td>
                            <td> <?= $pr_deposit['date'] ?> </td>
                            <td class="table2">
                              <?php if ($pr_deposit['status'] == 'approved') : ?>
                                <div class="badge badge-outline-success">Approved</div>
                              <?php endif; ?>
                              <?php if ($pr_deposit['status'] == 'declined') : ?>
                                <div class="badge badge-outline-danger">Declined</div>
                              <?php endif; ?>
                            </td>
                          </tr>
                        <?php endforeach; ?>
                      </tbody>
                    </table>
                  <?php else : ?>
                    <p>No transaction available</p>
                  <?php endif; ?>
                </div>
                <!-- /.card-body -->
              </div>
              <!-- /.card -->
            </div>

            <!-- settled withdrawal -->
            <div class="col-12 grid-margin">
              <div class="card">
                <div class="card-header">
                  <h4 class="card-title">Settled Withdrwals</h4>
                  <?php $PROCESSED_WITHDRAWAL = get_processed_withdrawal(); ?>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <?php if ($PROCESSED_WITHDRAWAL) : ?>
                    <table id="example5" class="table">
                      <thead>
                        <tr>
                          <th> Name </th>
                          <th> Wallet address </th>
                          <th> Account </th>
                          <th> Amount </th>
                          <th> Date </th>
                          <th> Status </th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php foreach ($PROCESSED_WITHDRAWAL as $pr_withdrawal) : ?>
                          <?php $user = get_user_id($pr_withdrawal['registration_id']) ?>
                          <tr>
                            <td> <?= $user['fullname'] ?> </td>
                            <td> <?= $pr_withdrawal['walletAddress'] ?> </td>
                            <td> <?= $pr_withdrawal['account'] ?> </td>
                            <td> <?= $pr_withdrawal['amount'] ?> </td>
                            <td> <?= $pr_withdrawal['date'] ?> </td>
                            <td class="table2">
                              <?php if ($pr_withdrawal['status'] == 'approved') : ?>
                                <div class="badge badge-outline-success">Approved</div>
                              <?php endif; ?>
                              <?php if ($pr_withdrawal['status'] == 'declined') : ?>
                                <div class="badge badge-outline-danger">Declined</div>
                              <?php endif; ?>
                            </td>
                          </tr>
                        <?php endforeach; ?>
                      </tbody>
                    </table>
                  <?php else : ?>
                    <p>No transaction available</p>
                  <?php endif; ?>
                </div>
                <!-- /.card-body -->
              </div>
              <!-- /.card -->
            </div>

          </div>
        </div>

        <!-- content-wrapper ends -->
        <!-- partial:../partials/_footer.html -->
        <footer class="footer">
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted d-block text-center text-sm-left d-sm-inline-block"></span>
            <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center"> <a href="https://www.bootstrapdash.com/bootstrap-admin-template/" target="_blank"></a> </span>
          </div>
        </footer>
        <!-- partial -->
      </div>



      <!-- main-panel ends -->
    </div>

    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->
  <!-- plugins:js -->
  <script src="../assets/vendors/js/vendor.bundle.base.js"></script>
  <!-- endinject -->
  <!-- Plugin js for this page -->
  <!-- End plugin js for this page -->
  <!-- inject:js -->
  <script src="../assets/js/off-canvas.js"></script>
  <script src="../assets/js/hoverable-collapse.js"></script>
  <script src="../assets/js/misc.js"></script>
  <script src="../assets/js/settings.js"></script>
  <script src="../assets/js/todolist.js"></script>
  <!-- endinject -->
  <!-- Custom js for this page -->
  <!-- End custom js for this page -->
  <!-- jQuery first, then Bootstrap JS -->
  <script src="../js/jquery.min.js"></script>
  <script src="../js/bootstrap.min.js"></script>

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js"></script>
  <script src="../dist/js/adminlte.js"></script>
  <script src="../plugins/datatables/jquery.dataTables.min.js"></script>
  <script src="../plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
  <script src="../plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
  <script src="../plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
  <script src="../plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
  <script src="../plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>

  <!-- Page specific script -->
  <script>
    $(function() {
      $("#example1").DataTable({
        "responsive": false,
        "lengthChange": true,
        "autoWidth": true,
        // "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
      }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
      $('#example2').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": false,
      });
    });
  </script>

  <script>
    $(function() {
      $("#example3").DataTable({
        "responsive": false,
        "lengthChange": true,
        "autoWidth": true,
        // "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
      }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
      $('#example2').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": false,
      });
    });
  </script>

  <script>
    $(function() {
      $("#example4").DataTable({
        "responsive": false,
        "lengthChange": true,
        "autoWidth": true,
        // "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
      }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
      $('#example2').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": false,
      });
    });
  </script>

  <script>
    $(function() {
      $("#example5").DataTable({
        "responsive": false,
        "lengthChange": true,
        "autoWidth": true,
        // "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
      }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
      $('#example2').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": false,
      });
    });
  </script>

  <!-- <script>
    $(function() {
      $("#example6").DataTable({
        "responsive": false,
        "lengthChange": true,
        "autoWidth": true,
        // "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
      }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
      $('#example2').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": false,
      });
    });
  </script> -->
</body>

</html>