<?php
session_start();

require_once("config/db.php");
require_once("utils/functions.php");
require_once("store/admin.php");
require_once("store/transact.php");

if (!$_SESSION['ADMIN']) redirect("login");
$USERS = get_all_users();
$ALL_DEPOSITS = get_processed_deposits();
$ALL_WITHDRAWAL = get_processed_withdrawal();

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title> Admin Dashboard</title>
  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="./css/bootstrap.min.css">
  <!-- Typography CSS -->
  <link rel="stylesheet" href="./css/typography.css">
  <!-- Responsive CSS -->
  <link rel="stylesheet" href="./css/responsive.css">
  <!-- plugins:css -->
  <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css">
  <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css">
  <!-- endinject -->
  <!-- Plugin css for this page -->
  <link rel="stylesheet" href="assets/vendors/jvectormap/jquery-jvectormap.css">
  <link rel="stylesheet" href="assets/vendors/flag-icon-css/css/flag-icon.min.css">
  <link rel="stylesheet" href="assets/vendors/owl-carousel-2/owl.carousel.min.css">
  <link rel="stylesheet" href="assets/vendors/owl-carousel-2/owl.theme.default.min.css">
  <!-- End plugin css for this page -->
  <!-- Theme style -->
  <!-- <link rel="stylesheet" href="dist/css/adminlte.min.css"> -->
  <!-- overlayScrollbars -->
  <!-- <link rel="stylesheet" href="plugins/overlayScrollbars/css/OverlayScrollbars.min.css"> -->
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Layout styles -->
  <link rel="stylesheet" href="assets/css/style.css">
  <!-- End layout styles -->
  <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>

<body>
  <?php include_once "includes/alert.php"; ?>
  <div class="container-scroller">
    <!-- partial:partials/_sidebar.html -->
    <nav class="sidebar sidebar-offcanvas" id="sidebar">
      <div class="sidebar-brand-wrapper d-none d-lg-flex align-items-center justify-content-center fixed-top">

      </div>
      <ul class="nav">
        <li class="nav-item profile">
          <div class="profile-desc">
            <div class="profile-pic">
              <div class="count-indicator">
                <img class="img-xs rounded-circle " src="assets/images/faces/face15.jpg" alt="">
                <span class="count bg-success"></span>
              </div>
              <div class="profile-name">
                <h5 class="mb-0 font-weight-normal">Admin</h5>
                <span>Dashboard</span>
              </div>
            </div>
            <a href="#" id="profile-dropdown" data-toggle="dropdown"><i class="mdi mdi-dots-vertical"></i></a>
            <div class="dropdown-menu dropdown-menu-right sidebar-dropdown preview-list" aria-labelledby="profile-dropdown">
              <a href="#" class="dropdown-item preview-item">
                <div class="preview-thumbnail">
                  <div class="preview-icon bg-dark rounded-circle">
                    <i class="mdi mdi-settings text-primary"></i>
                  </div>
                </div>
                <div class="preview-item-content">
                  <p class="preview-subject ellipsis mb-1 text-small">Account settings</p>
                </div>
              </a>
              <div class="dropdown-divider"></div>
              <a href="#" class="dropdown-item preview-item">
                <div class="preview-thumbnail">
                  <div class="preview-icon bg-dark rounded-circle">
                    <i class="mdi mdi-onepassword  text-info"></i>
                  </div>
                </div>
                <div class="preview-item-content">
                  <p class="preview-subject ellipsis mb-1 text-small">Change Password</p>
                </div>
              </a>
              <div class="dropdown-divider"></div>
              <a href="#" class="dropdown-item preview-item">
                <div class="preview-thumbnail">
                  <div class="preview-icon bg-dark rounded-circle">
                    <i class="mdi mdi-calendar-today text-success"></i>
                  </div>
                </div>
                <div class="preview-item-content">
                  <p class="preview-subject ellipsis mb-1 text-small">To-do list</p>
                </div>
              </a>
            </div>
          </div>
        </li>
        <li class="nav-item nav-category">
          <span class="nav-link">Navigation</span>
        </li>
        <li class="nav-item menu-items">
          <a class="nav-link" href="index.php">
            <span class="menu-icon">
              <i class="mdi mdi-speedometer"></i>
            </span>
            <span class="menu-title">Dashboard</span>
          </a>
        </li>

        <li class="nav-item menu-items">
          <a class="nav-link" href="pages/basic_elements.php">
            <span class="menu-icon">
              <i class="mdi mdi-playlist-play"></i>
            </span>
            <span class="menu-title">Edit wallet</span>
          </a>
        </li>
        <li class="nav-item menu-items">
          <a class="nav-link" href="pages/basic-table.php">
            <span class="menu-icon">
              <i class="mdi mdi-table-large"></i>
            </span>
            <span class="menu-title">Deposit & withdrawal</span>
          </a>
        </li>




      </ul>
    </nav>
    <!-- partial -->
    <div class="container-fluid page-body-wrapper">
      <!-- partial:partials/_navbar.html -->
      <nav class="navbar p-0 fixed-top d-flex flex-row">
        <div class="navbar-brand-wrapper d-flex d-lg-none align-items-center justify-content-center">
          <a class="navbar-brand brand-logo-mini" href="index.php"><img src="assets/images/logo-mini.svg" alt="logo" /></a>
        </div>
        <div class="navbar-menu-wrapper flex-grow d-flex align-items-stretch">
          <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
            <span class="mdi mdi-menu"></span>
          </button>
          <ul class="navbar-nav w-100">
            <li class="nav-item w-100">
              <form class="nav-link mt-2 mt-md-0 d-none d-lg-flex search">
                <input type="text" class="form-control" placeholder="Search products">
              </form>
            </li>
          </ul>
          <ul class="navbar-nav navbar-nav-right">
            <li class="nav-item dropdown d-none d-lg-block">
              <a class="nav-link btn btn-success create-new-button" id="createbuttonDropdown" data-toggle="dropdown" aria-expanded="false" href="#">Welcome to your admin dashboard</a>
              <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="createbuttonDropdown">
                <h6 class="p-3 mb-0">Projects</h6>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-file-outline text-primary"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject ellipsis mb-1">Software Development</p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-web text-info"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject ellipsis mb-1">UI Development</p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-layers text-danger"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject ellipsis mb-1">Software Testing</p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <p class="p-3 mb-0 text-center">See all projects</p>
              </div>
            </li>
            <li class="nav-item nav-settings d-none d-lg-block">
              <a class="nav-link" href="#">
                <i class="mdi mdi-view-grid"></i>
              </a>
            </li>
            <li class="nav-item dropdown border-left">
              <a class="nav-link count-indicator dropdown-toggle" id="messageDropdown" href="#" data-toggle="dropdown" aria-expanded="false">
                <i class="mdi mdi-email"></i>
                <span class="count bg-success"></span>
              </a>

            </li>
            <li class="nav-item dropdown border-left">
              <a class="nav-link count-indicator dropdown-toggle" id="notificationDropdown" href="#" data-toggle="dropdown">
                <i class="mdi mdi-bell"></i>
                <span class="count bg-danger"></span>
              </a>
              <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
                <h6 class="p-3 mb-0">Notifications</h6>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-calendar text-success"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject mb-1">Event today</p>
                    <p class="text-muted ellipsis mb-0"> Just a reminder that you have an event today </p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-settings text-danger"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject mb-1">Settings</p>
                    <p class="text-muted ellipsis mb-0"> Update dashboard </p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-link-variant text-warning"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject mb-1">Launch Admin</p>
                    <p class="text-muted ellipsis mb-0"> New admin wow! </p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <p class="p-3 mb-0 text-center">See all notifications</p>
              </div>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link" id="profileDropdown" href="#" data-toggle="dropdown">
                <div class="navbar-profile">
                  <img class="img-xs rounded-circle" src="assets/images/faces/face15.jpg" alt="">
                  <p class="mb-0 d-none d-sm-block navbar-profile-name">Admin dashboard</p>
                  <i class="mdi mdi-menu-down d-none d-sm-block"></i>
                </div>
              </a>
              <div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="profileDropdown">
                <h6 class="p-3 mb-0">Profile</h6>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-settings text-success"></i>
                    </div>
                  </div>
                  <div class="preview-item-content">
                    <p class="preview-subject mb-1">Settings</p>
                  </div>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item preview-item">
                  <div class="preview-thumbnail">
                    <div class="preview-icon bg-dark rounded-circle">
                      <i class="mdi mdi-logout text-danger"></i>
                    </div>
                  </div>
                  <form class="preview-item-content" action="../handlers/auth_handler.php" method="post">
                    <button type="submit" name="logout" style="background: transparent; outline:none; border:none; color:white;" class="preview-subject mb-1">Logout</button>
                  </form>
                </a>
                <div class="dropdown-divider"></div>
                <p class="p-3 mb-0 text-center">Advanced settings</p>
              </div>
            </li>
          </ul>
          <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
            <span class="mdi mdi-format-line-spacing"></span>
          </button>
        </div>
      </nav>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">

          

          <div class="row">
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <div class="row">
                    <div class="col-9">
                      <div class="d-flex align-items-center align-self-start">
                        <h3 class="mb-0"><?= count($USERS) ?></h3>
                        <p class="text-success ml-2 mb-0 font-weight-medium">+3 New</p>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="icon icon-box-success ">
                        <span class="mdi mdi-arrow-top-right icon-item"></span>
                      </div>
                    </div>
                  </div>
                  <h6 class="text-muted font-weight-normal">Total Users</h6>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <div class="row">
                    <div class="col-9">
                      <div class="d-flex align-items-center align-self-start">
                        <?php
                        $amount = 0;
                        $sql = "SELECT * FROM deposits WHERE status = 'approved'";
                        $res = mysqli_query($connection, $sql);

                        while ($row = mysqli_fetch_assoc($res)) {
                          $amount += intval($row['amount']);
                        }
                        // echo($amount);
                        ?>
                        <h3 class="mb-0"><?= $amount ?></h3>
                        <p class="text-success ml-2 mb-0 font-weight-medium">USD</p>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="icon icon-box-success">
                        <span class="mdi mdi-arrow-top-right icon-item"></span>
                      </div>
                    </div>
                  </div>
                  <h6 class="text-muted font-weight-normal">Total Deposit</h6>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <div class="row">
                    <div class="col-9">
                      <div class="d-flex align-items-center align-self-start">
                        <?php
                        $amount = 0;
                        $sql = "SELECT * FROM withdrawals WHERE status = 'approved'";
                        $res = mysqli_query($connection, $sql);

                        while ($row = mysqli_fetch_assoc($res)) {
                          $amount += intval($row['amount']);
                        }
                        // echo($amount);
                        ?>
                        <h3 class="mb-0"><?= $amount ?></h3>
                        <p class="text-danger ml-2 mb-0 font-weight-medium">USD</p>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="icon icon-box-danger">
                        <span class="mdi mdi-arrow-bottom-left icon-item"></span>
                      </div>
                    </div>
                  </div>
                  <h6 class="text-muted font-weight-normal">Total Withdrawal</h6>
                </div>
              </div>
            </div>
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <div class="row">
                    <div class="col-9">
                      <div class="d-flex align-items-center align-self-start">
                        <h3 class="mb-0">7</h3>
                        <p class="text-success ml-2 mb-0 font-weight-medium">A/D</p>
                      </div>
                    </div>
                    <div class="col-3">
                      <div class="icon icon-box-success ">
                        <span class="mdi mdi-arrow-top-right icon-item"></span>
                      </div>
                    </div>
                  </div>
                  <h6 class="text-muted font-weight-normal">Pending Transactions</h6>
                </div>
              </div>
            </div>
          </div>

          <!-- all users -->
          <div class="row">
            <div class="col-12 grid-margin">
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title">All Users</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                  <table id="example1" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th> Client Name </th>
                        <th> User ID </th>
                        <th> Email </th>
                        <th> Plans </th>
                        <!-- <th> Start Date </th> -->
                        <th> Action </th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $USERS = get_all_users(); ?>
                      <?php foreach ($USERS as $users) : ?>
                        <tr>
                          <td>
                            <img src="../user/profileImages/<?= $users['profile_pic'] ?>" alt="image" />
                            <span class="pl-2"> <?= $users['fullname'] ?> </span>
                          </td>
                          <td> <?= $users['registration_id'] ?> </td>
                          <td> <?= $users['email'] ?> </td>
                          <td> <?= $users['package'] ?> </td>
                          <!-- <td> <?= $users['registration_date'] ?> </td> -->
                          <td class="text-right py-0 align-middle">
                            <div class="btn-group btn-group-sm">
                              <?php if ($users['status'] == 'suspended') : ?>
                                <a href="pages/approve.php?id=<?= $users['registration_id'] ?>" class="badge badge-outline-success">
                                  <span>Approve</span>
                                </a>
                              <?php endif; ?>
                              <a href="pages/edit_user.php?id=<?= $users['registration_id'] ?>" class="badge badge-outline-danger">
                                <span>Edit</span>
                              </a>
                            </div>
                          </td>
                        </tr>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
                <!-- /.card-body -->
              </div>
              <!-- /.card -->
            </div>
            <!-- /.col -->
          </div>

          <div class="row">
            <div class="col-sm-4 grid-margin">
              <div class="card">
                <div class="card-body">
                  <h5>Referal Links</h5>
                  <div class="row">
                    <div class="col-8 col-sm-12 col-xl-8 my-auto">
                      <div class="d-flex d-sm-block d-md-flex align-items-center">
                        <h2 class="mb-0">5</h2>
                        <p class="text-success ml-2 mb-0 font-weight-medium">People</p>
                      </div>
                      <h6 class="text-muted font-weight-normal">give bonus when people register with their referal link</h6>
                    </div>
                    <div class="col-4 col-sm-12 col-xl-4 text-center text-xl-right">
                      <i class="icon-lg mdi mdi-codepen text-primary ml-auto"></i>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-sm-4 grid-margin">
              <div class="card">
                <div class="card-body">
                  <h5>total profit added</h5>
                  <div class="row">
                    <div class="col-8 col-sm-12 col-xl-8 my-auto">
                      <div class="d-flex d-sm-block d-md-flex align-items-center">
                        <h2 class="mb-0">$45850</h2>
                        <p class="text-success ml-2 mb-0 font-weight-medium">All users</p>
                      </div>
                      <h6 class="text-muted font-weight-normal"> total profit of every user</h6>
                    </div>
                    <div class="col-4 col-sm-12 col-xl-4 text-center text-xl-right">
                      <i class="icon-lg mdi mdi-wallet-travel text-danger ml-auto"></i>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-sm-4 grid-margin">
              <div class="card">
                <div class="card-body">
                  <h5>Active users</h5>
                  <div class="row">
                    <div class="col-8 col-sm-12 col-xl-8 my-auto">
                      <div class="d-flex d-sm-block d-md-flex align-items-center">
                        <h2 class="mb-0"><?= count($USERS) ?></h2>
                        <p class="text-danger ml-2 mb-0 font-weight-medium">2 new </p>
                      </div>
                      <h6 class="text-muted font-weight-normal">acounts except deleted ones</h6>
                    </div>
                    <div class="col-4 col-sm-12 col-xl-4 text-center text-xl-right">
                      <i class="icon-lg mdi mdi-monitor text-success ml-auto"></i>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
              
              <!-- fund savings balance -->
            <div class="col-md-12 col-xl-4 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Fund Savings</h4>
                  <form class="add-items " action="handlers/user_handler.php" method="post">
                    <select class="form-control" required name="user" id="">
                      <option value="">Select user</option>
                      <?php foreach ($USERS as $user) : ?>
                        <option value="<?= $user['registration_id'] ?>"> <?= $user['fullname'] ?> </option>
                      <?php endforeach; ?>
                    </select>
                    <br>
                    <input type="text" required name="amount" class="form-control" placeholder="type Amount"><br>
                    <button name="fund_saving" type="submit" class="add btn btn-primary">Add</button>

                  </form>
                  <div class="list-wrapper">

                    <ul class="d-flex flex-column-reverse text-white todo-list todo-list-custom">



                      <li>
                        <div class="form-check form-check-primary">
                          <label class="form-check-label">
                            <input class="checkbox" required type="checkbox"> Remember This User </label>
                        </div>
                        <i class="remove mdi mdi-close-box"></i>
                      </li>
                    </ul>
                  </div>
                </div>

              </div>
            </div>
            
            <!-- fund shares balance -->
            <div class="col-md-12 col-xl-4 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Fund Investment</h4>
                  <form class="add-items " action="handlers/user_handler.php" method="post">
                    <select class="form-control" required name="user" id="">
                      <option value="">Select user</option>
                      <?php foreach ($USERS as $user) : ?>
                        <option value="<?= $user['registration_id'] ?>"> <?= $user['fullname'] ?> </option>
                      <?php endforeach; ?>
                    </select>
                    <br>
                    <input type="text" required name="amount" class="form-control" placeholder="type Amount"><br>
                    <button name="fund_shares" type="submit" class="add btn btn-primary">Add</button>
                    <br> <br>
                    <div class="list-wrapper">

                      <ul class="d-flex flex-column-reverse text-white todo-list todo-list-custom">



                        <li>
                          <div class="form-check form-check-primary">
                            <label class="form-check-label">
                              <input class="checkbox" required type="checkbox"> Remember This User </label>
                          </div>
                          <i class="remove mdi mdi-close-box"></i>
                        </li>
                      </ul>
                    </div>
                  </form>
                </div>

              </div>
            </div>
            
            <!-- fund bonus balance -->
            <div class="col-md-12 col-xl-4 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Profit For Users</h4>
                  <form class="add-items " action="handlers/user_handler.php" method="post">
                    <select class="form-control" required name="user" id="">
                      <option value="">Select user</option>
                      <?php foreach ($USERS as $user) : ?>
                        <option value="<?= $user['registration_id'] ?>"> <?= $user['fullname'] ?> </option>
                      <?php endforeach; ?>
                    </select><br>
                    <input type="text" required name="amount" class="form-control" placeholder="type Amount"><br>
                    <button name="bonus" type="submit" class="add btn btn-primary">Add</button>
                    <br> <br>
                    <div class="list-wrapper">

                      <ul class="d-flex flex-column-reverse text-white">



                        <li>
                          <div class="form-check form-check-primary">
                            <label class="form-check-label">
                              <input class="checkbox" required type="checkbox"> Remember This User </label>
                          </div>
                          <i class="remove mdi mdi-close-box"></i>
                        </li>
                      </ul>
                    </div>
                  </form>
                </div>
              </div>
            </div>
            
            <!-- remove from savings balance -->
            <div class="col-md-12 col-xl-4 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Remove From Savings</h4>
                  <form class="add-items " action="handlers/user_handler.php" method="post">
                    <select class="form-control" required name="user" id="">
                      <option value="">Select user</option>
                      <?php foreach ($USERS as $user) : ?>
                        <option value="<?= $user['registration_id'] ?>"> <?= $user['fullname'] ?> </option>
                      <?php endforeach; ?>
                    </select>
                    <br>
                    <input type="text" required name="amount" class="form-control" placeholder="type Amount"><br>
                    <button name="remove_saving" type="submit" class="add btn btn-primary">Remove</button>

                  </form>
                  <div class="list-wrapper">

                    <ul class="d-flex flex-column-reverse text-white todo-list todo-list-custom">



                      <li>
                        <div class="form-check form-check-primary">
                          <label class="form-check-label">
                            <input class="checkbox" required type="checkbox"> Remember This User </label>
                        </div>
                        <i class="remove mdi mdi-close-box"></i>
                      </li>
                    </ul>
                  </div>
                </div>

              </div>
            </div>

            <!-- remove from shares balance -->
            <div class="col-md-12 col-xl-4 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Remove From Investments</h4>
                  <form class="add-items " action="handlers/user_handler.php" method="post">
                    <select class="form-control" required name="user" id="">
                      <option value="">Select user</option>
                      <?php foreach ($USERS as $user) : ?>
                        <option value="<?= $user['registration_id'] ?>"> <?= $user['fullname'] ?> </option>
                      <?php endforeach; ?>
                    </select>
                    <br>
                    <input type="text" required name="amount" class="form-control" placeholder="type Amount"><br>
                    <button name="remove_shares" type="submit" class="add btn btn-primary">Remove</button>
                    <br> <br>
                    <div class="list-wrapper">

                      <ul class="d-flex flex-column-reverse text-white todo-list todo-list-custom">



                        <li>
                          <div class="form-check form-check-primary">
                            <label class="form-check-label">
                              <input class="checkbox" required type="checkbox"> Remember This User </label>
                          </div>
                          <i class="remove mdi mdi-close-box"></i>
                        </li>
                      </ul>
                    </div>
                  </form>
                </div>

              </div>
            </div>

            <!-- remove from bonus balance -->
            <div class="col-md-12 col-xl-4 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Remove Profit From User</h4>
                  <form class="add-items " action="handlers/user_handler.php" method="post">
                    <select class="form-control" required name="user" id="">
                      <option value="">Select user</option>
                      <?php foreach ($USERS as $user) : ?>
                        <option value="<?= $user['registration_id'] ?>"> <?= $user['fullname'] ?> </option>
                      <?php endforeach; ?>
                    </select><br>
                    <input type="text" required name="amount" class="form-control" placeholder="type Amount"><br>
                    <button name="remove_bonus" type="submit" class="add btn btn-primary">Remove</button>
                    <br> <br>
                    <div class="list-wrapper">

                      <ul class="d-flex flex-column-reverse text-white">



                        <li>
                          <div class="form-check form-check-primary">
                            <label class="form-check-label">
                              <input class="checkbox" required type="checkbox"> Remember This User </label>
                          </div>
                          <i class="remove mdi mdi-close-box"></i>
                        </li>
                      </ul>
                    </div>
                  </form>
                </div>
              </div>
            </div>
            
            <!--delete user-->
            <div class="col-md-12 col-xl-4 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Delete Users</h4>
                  <form class="add-items " action="handlers/user_handler.php" method="post">
                    <select class="form-control" required name="user" id="">
                      <option value="">Select user</option>
                      <?php foreach ($USERS as $user) : ?>
                        <option value="<?= $user['registration_id'] ?>"> <?= $user['fullname'] ?> </option>
                      <?php endforeach; ?>
                    </select><br>

                    <button name="delete_user" type="submit" class="add btn btn-primary">Delete</button>
                    <br> <br>
                    <div class="list-wrapper">
                      <ul class="d-flex flex-column-reverse text-white">
                        <li>
                          <div class="form-check form-check-primary">
                            <label class="form-check-label">
                              <input class="checkbox" required type="checkbox">Are you sure you want to delete this user </label>
                          </div>
                          <i class="remove mdi mdi-close-box"></i>
                        </li>
                      </ul>
                    </div>
                  </form>
                </div>
              </div>
            </div>
            
            <!--pause user-->
            <!-- <div class="col-md-12 col-xl-4 grid-margin stretch-card">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Pause users</h4>
                  <form class="add-items" action="handlers/user_handler.php" method="post">
                    <select class="form-control" required name="user" id="">
                      <option value="">Select user</option>
                      <?php foreach ($USERS as $user) : ?>
                        <option value="<?= $user['registration_id'] ?>"> <?= $user['fullname'] ?> </option>
                      <?php endforeach; ?>
                    </select><br>

                    <button type="submit" name="pause_user" class="add btn btn-primary">Pause</button>
                    <br> <br>
                    <div class="list-wrapper">

                      <ul class="d-flex flex-column-reverse text-white">



                        <li>
                          <div class="form-check form-check-primary">
                            <label class="form-check-label">
                              <input class="checkbox" required type="checkbox">Are you sure you want to Pause this user </label>
                          </div>
                          <i class="remove mdi mdi-close-box"></i>
                        </li>
                      </ul>
                    </div>
                  </form>
                </div>
              </div>
            </div> -->
            
          </div>


          <div class="row">
            <div class="col-12">
              <div class="card">
                <div class="card-body">
                  <h4 class="card-title">Visitors by Countries</h4>
                  <div class="row">
                    <div class="col-md-5">
                      <div class="table-responsive">
                        <table class="table">
                          <tbody>
                            <tr>
                              <td>
                                <i class="flag-icon flag-icon-us"></i>
                              </td>
                              <td>USA</td>
                              <td class="text-right"> 1500 </td>
                              <td class="text-right font-weight-medium"> 56.35% </td>
                            </tr>
                            <tr>
                              <td>
                                <i class="flag-icon flag-icon-de"></i>
                              </td>
                              <td>Germany</td>
                              <td class="text-right"> 800 </td>
                              <td class="text-right font-weight-medium"> 33.25% </td>
                            </tr>
                            <tr>
                              <td>
                                <i class="flag-icon flag-icon-au"></i>
                              </td>
                              <td>Australia</td>
                              <td class="text-right"> 760 </td>
                              <td class="text-right font-weight-medium"> 15.45% </td>
                            </tr>
                            <tr>
                              <td>
                                <i class="flag-icon flag-icon-gb"></i>
                              </td>
                              <td>United Kingdom</td>
                              <td class="text-right"> 450 </td>
                              <td class="text-right font-weight-medium"> 25.00% </td>
                            </tr>
                            <tr>
                              <td>
                                <i class="flag-icon flag-icon-ro"></i>
                              </td>
                              <td>Romania</td>
                              <td class="text-right"> 620 </td>
                              <td class="text-right font-weight-medium"> 10.25% </td>
                            </tr>
                            <tr>
                              <td>
                                <i class="flag-icon flag-icon-br"></i>
                              </td>
                              <td>Brasil</td>
                              <td class="text-right"> 230 </td>
                              <td class="text-right font-weight-medium"> 75.00% </td>
                            </tr>
                          </tbody>
                        </table>
                      </div>
                    </div>
                    <div class="col-md-7">
                      <div id="audience-map" class="vector-map"></div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

        </div>
        <!-- content-wrapper ends -->
        <!-- partial:partials/_footer.html -->
        <footer class="footer">
          <div class="d-sm-flex justify-content-center justify-content-sm-between">
            <span class="text-muted d-block text-center text-sm-left d-sm-inline-block"></span>
            <span class="float-none float-sm-right d-block mt-1 mt-sm-0 text-center"> <a href="https://www.bootstrapdash.com/bootstrap-admin-template/" target="_blank"></a> </span>
          </div>
        </footer>
        <!-- partial -->
      </div>
      <!-- main-panel ends -->
    </div>
    <!-- page-body-wrapper ends -->
  </div>
  <!-- container-scroller -->
  <!-- plugins:js -->
  <script src="assets/vendors/js/vendor.bundle.base.js"></script>
  <!-- endinject -->
  <!-- Plugin js for this page -->
  <script src="assets/vendors/chart.js/Chart.min.js"></script>
  <script src="assets/vendors/progressbar.js/progressbar.min.js"></script>
  <script src="assets/vendors/jvectormap/jquery-jvectormap.min.js"></script>
  <script src="assets/vendors/jvectormap/jquery-jvectormap-world-mill-en.js"></script>
  <script src="assets/vendors/owl-carousel-2/owl.carousel.min.js"></script>
  <!-- End plugin js for this page -->
  <!-- inject:js -->
  <script src="assets/js/off-canvas.js"></script>
  <script src="assets/js/hoverable-collapse.js"></script>
  <script src="assets/js/misc.js"></script>
  <script src="assets/js/settings.js"></script>
  <script src="assets/js/todolist.js"></script>
  <!-- endinject -->
  <!-- Custom js for this page -->
  <script src="assets/js/dashboard.js"></script>
  <!-- End custom js for this page -->
  <!-- jQuery first, then Bootstrap JS -->
  <script src="js/jquery.min.js"></script>
  <script src="js/bootstrap.min.js"></script>

  <!-- jQuery -->
  <script src="plugins/jquery/jquery.min.js"></script>
  <script src="dist/js/adminlte.js"></script>
  <script src="plugins/datatables/jquery.dataTables.min.js"></script>
  <script src="plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
  <script src="plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
  <script src="plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
  <script src="plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
  <script src="plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>

  <!-- Page specific script -->
  <script>
    $(function() {
      $("#example1").DataTable({
        "responsive": false,
        "lengthChange": true,
        "autoWidth": true,
        // "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
      }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
      $('#example2').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": false,
      });
    });
  </script>
</body>

</html>