<?php

// session_start();
require_once "../config/db.php";
require_once "../utils/functions.php";
require_once "../utils/errors.php";
require_once "../store/admin.php";

if (isset($_POST['reg_user'])) {

    $first_name = sanitize($_POST['firstName']);
    $last_name = sanitize($_POST['lastName']);
    $email = sanitize($_POST['email']);
    $password = sanitize($_POST['password']);
    // echo $password_confirm = sanitize($_POST['password_confirm']);
    $ref_id = sanitize($_POST['referee']) ?? 'admin';
    $reg_id = generateRandomString(15);
    $fullname = "$first_name $last_name";
    $ref_code = generateRandomString(8);
    $check_email = get_user_email($email);

    try {
        if($check_email) throw new AppException("Email already exist");
        if (empty($ref_id)) {
            $ref_id = "Admin";
        }

        $password = encrypt_decrypt($password);
        $query = "INSERT INTO `users`(`registration_id`, `fullname`, `email`, `password`,`package`, `referral_code`, `referee_code`, `registration_date`,`status`) 
        VALUES ('$reg_id','$fullname','$email','$password','basic','$ref_code','$ref_id',now(),'active')";
        $res = makeQuery($query);
        set_alert("User registration success");
        redirect("../pages/basic_elements");
    } catch (AppException $e) {
        set_alert($e->message, $e->type);
        redirect("../pages/basic_element");
    }
}

function encrypt_decrypt($string, $action = 'encrypt')
{
    $encrypt_method = "AES-256-CBC";
    $secret_key = 'AA74CDCCrferefesc2BBRT935136HH7B63C27'; // user define private key
    $secret_iv = '5fgf54645dsfdfsfc5HJ5g27'; // user define secret key
    $key = hash('sha256', $secret_key);
    $iv = substr(hash('sha256', $secret_iv), 0, 16); // sha256 is hash_hmac_algo
    if ($action == 'encrypt') {
        $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
        $output = base64_encode($output);
        return $output;
    } else if ($action == 'decrypt') {
        $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
        return $output;
    }
    
}

function generateRandomString($length) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

// fund savings
if (isset($_POST['fund_saving'])) 
{
    // var_dump($_POST);

    $id = $_POST['user'];
    $amount = intval($_POST['amount']);
    // var_dump($id);
    $user = get_user_id($id);
    // var_dump($user);
    $old_bal = $user['balance'];
    $new_bal = $amount + $old_bal;
    // var_dump($new_bal);
    // exit;


    try 
    {
        $query = "UPDATE `users` SET `balance`=$new_bal WHERE `registration_id`='$id'";  
        $res = makeQuery($query);
        
        if(!$res) throw new AppException("Process failed");
        set_alert("Funds added!");
        redirect("../");
        exit;
    } 
    catch (AppException $e) 
    {
        set_alert($e->message, $e->type);
        redirect("../");    
        exit;
    }
}

// fund shares balance
if (isset($_POST['fund_shares'])) 
{
    // var_dump($_POST);

    $id = $_POST['user'];
    $amount = intval($_POST['amount']);
    // var_dump($id);
    $user = get_user_id($id);
    // var_dump($user);
    $old_bal = $user['shares'];
    $new_bal = $amount + $old_bal;
    // var_dump($new_bal);
    // exit;


    try 
    {
        $query = "UPDATE `users` SET `shares`=$new_bal WHERE `registration_id`='$id'";  
        $res = makeQuery($query);
        
        if(!$res) throw new AppException("Process failed");
        set_alert("Funds added!");
        redirect("../");
        exit;
    } 
    catch (AppException $e) 
    {
        set_alert($e->message, $e->type);
        redirect("../");    
        exit;
    }
}

// give user bonus
if (isset($_POST['bonus'])) 
{

    $id = $_POST['user'];
    $amount = intval($_POST['amount']);
    $user = get_user_id($id);
    $old_profit = $user['profit'];
    $new_profit = $amount + $old_profit;


    try 
    {
        $query = "UPDATE `users` SET `profit`= $new_profit WHERE `registration_id`='$id'";  
        $res = makeQuery($query);
        
        if(!$res) throw new AppException("Process failed");
        set_alert("Funds added!");
        redirect("../");
        exit;
    } 
    catch (AppException $e) 
    {
        set_alert($e->message, $e->type);
        redirect("../");    
        exit;
    }
}

// remove from savings
if (isset($_POST['remove_saving'])) 
{
    

    $id = $_POST['user'];
    $amount = intval($_POST['amount']);
    
    $user = get_user_id($id);
    
    $old_bal = $user['balance'];
    $new_bal = $old_bal - $amount;

    try 
    {
        $query = "UPDATE `users` SET `balance`=$new_bal WHERE `registration_id`='$id'";  
        $res = makeQuery($query);
        
        if(!$res) throw new AppException("Process failed");
        set_alert("Funds removed!");
        redirect("../");
        exit;
    } 
    catch (AppException $e) 
    {
        set_alert($e->message, $e->type);
        redirect("../");    
        exit;
    }
}

// remove from shares 
if (isset($_POST['remove_shares'])) 
{
    // var_dump($_POST);

    $id = $_POST['user'];
    $amount = intval($_POST['amount']);
    // var_dump($id);
    $user = get_user_id($id);
    // var_dump($user);
    $old_bal = $user['shares'];
    $new_bal = $old_bal - $amount;
    // var_dump($new_bal);
    // exit;


    try 
    {
        $query = "UPDATE `users` SET `shares`=$new_bal WHERE `registration_id`='$id'";  
        $res = makeQuery($query);
        
        if(!$res) throw new AppException("Process failed");
        set_alert("Funds removed!");
        redirect("../");
        exit;
    } 
    catch (AppException $e) 
    {
        set_alert($e->message, $e->type);
        redirect("../");    
        exit;
    }
}

// remove user bonus
if (isset($_POST['remove_bonus'])) 
{

    $id = $_POST['user'];
    $amount = intval($_POST['amount']);
    $user = get_user_id($id);
    $old_profit = $user['profit'];
    $new_profit = $old_profit - $amount;


    try 
    {
        $query = "UPDATE `users` SET `profit`= $new_profit WHERE `registration_id`='$id'";  
        $res = makeQuery($query);
        
        if(!$res) throw new AppException("Process failed");
        set_alert("Funds removed!");
        redirect("../");
        exit;
    } 
    catch (AppException $e) 
    {
        set_alert($e->message, $e->type);
        redirect("../");    
        exit;
    }
}

// add to active shares
if(isset($_POST['add_active']))
{
    $amount = sanitize($_POST['amount']);
    $amount = intval($amount);
    $user = sanitize($_POST['user']);
    $t_id = uniqid("");
    // var_dump($t_id);
    // exit;

    try
    {
        $query = "INSERT INTO `shares`(`registration_id`, `transaction_id`, `amount`, `samount`, `status`, `plan`) VALUES ('$user','$t_id',$amount,$amount,'active','Basic')";
        $res = makeQuery($query);

        if(!$res) throw new AppException("Process failed");
        set_alert("Active shares added");
        redirect("../index");
    }
    catch(AppException $e)
    {
        set_alert($e->message, $e->type);
        redirect("../index");
    }
}

// delete user
if (isset($_POST['delete_user'])) 
{
    // var_dump($_POST);
    // exit;
    $user = $_POST['user'];
    // var_dump($user);
    // exit;

    try 
    {
        $query = "DELETE FROM `users` WHERE `registration_id`='$user'";
        $res = makeQuery($query);
        // var_dump("1");
        // exit;
        
        $query_dep = "DELETE FROM `deposits` WHERE `registration_id`='$user'";
        $res_dep = makeQuery($query_dep);
        // var_dump("2");
        // exit;
        
        $query_with = "DELETE FROM `withdrawals` WHERE `registration_id`='$user'";
        $res_with = makeQuery($query_with);
        // var_dump("3");
        // exit;

        if(!$res && !$res_dep && !$res_with) throw new AppException("Error occured!");
        set_alert("User deleted");
        redirect("../");

    } 
    catch (AppException $e) 
    {
        set_alert($e->message, $e->type);
        redirect("../");
    }
}

// pause user
if (isset($_POST['pause_user'])) 
{
    $user = $_POST['user'];

    try 
    {
        $query = "UPDATE `users` SET `status`='suspended' WHERE `registration_id`='$user'";
        $res = makeQuery($query);

        if(!$res) throw new AppException("Error occured!");
        set_alert("User Paused");
        redirect("../");

    } 
    catch (AppException $e) 
    {
        set_alert($e->message, $e->type);
        redirect("../");
    }
}

// edit user details
if (isset($_POST['edit_user'])) {
    
    $id = $_GET['id'];
    
    // variables
    $name = sanitize($_POST['name']);
    $email = sanitize($_POST['email']);
    $password = encrypt_decrypt(sanitize($_POST['password']));
    $wallet = sanitize($_POST['wallet']);
    $balance = sanitize(intval($_POST['balance']));
    $new_balance = intval($balance);
    $shares = sanitize(intval($_POST['shares']));
    $new_shares = intval($shares);
    $profit = sanitize(intval($_POST['profit']));
    $new_profit = intval($profit);

    try {
        $query = "UPDATE `users` SET `fullname`='$name', `email`='$email', `password`='$password', `balance`=$new_balance, `shares`=$new_shares, `profit`=$new_profit, `wallet`='$wallet' WHERE `registration_id`='$id'";
        $res = makeQuery($query);

        if(!$res) throw new AppException("Update failed");
        set_alert("User details updated");
        redirect("../pages/edit_user?id=$id");
        exit;
    } catch (AppException $e) {
        set_alert($e->message, $e->type);
        redirect("../pages/edit_user?id=$id");
        exit;
    }
}

function get_useramount($table,$id){
    global $connection;
    $amount = 0;

    $sql = "SELECT * FROM `$table` WHERE registration_id = '$id' AND status = 'approved'";
    $res = mysqli_query($connection,$sql);
    while($row = mysqli_fetch_assoc($res)){
        $amount += $row['amount'];
    }
    return $amount;
}

function get_allprofit(){
    global $connection;
    $amount = 0;

    $sql = "SELECT * FROM `users`";
    $res = mysqli_query($connection,$sql);
    while($row = mysqli_fetch_assoc($res)){
        $amount += $row['profit'];
        $amount += $row['bonus'];
    }
    return $amount;
}