<?php

session_start();
require_once "../config/db.php";
require_once "../utils/functions.php";
require_once "../utils/errors.php";
require_once "../store/admin.php";


// registration logic
if (isset($_POST['register'])) {
    try 
    {
        // var_dump($_POST);

        // collect and sanitize input 
        $name = sanitize($_POST['name']);
        $email = sanitize($_POST['email']);
        $password = sanitize($_POST['password']);

        // check if email exist in database
        $check_email = get_admin_email($email);
        if($check_email) throw new AppException("Email registered to another user");
        
        // hash password
        $hash_password = password_hash($password, PASSWORD_DEFAULT);

        // create admin unique id
        $id = uniqid("adm_");

        // insert into database
        $query = "INSERT INTO `admin`(`admin_id`, `Username`, `email`, `password`) VALUES('$id', '$name', '$email', '$hash_password')";
        $res = makeQuery($query);

        if(!$res) throw new AppException("Error ocurred!");
        set_alert("Registration success");
        redirect("../login");
    } 
    catch (AppException $e) 
    {
        set_alert($e->message, $e->type);
        redirect("../register");
    }
}

// login logic
if (isset($_POST['login'])) {
   try 
   {

    // collect and sanitize user input
    $email = sanitize($_POST['email']);
    $password = sanitize($_POST['password']);

    // check if email in database
    $check_email = get_admin_email($email);
    if(!$check_email) throw new AppException("Email not recognized");
    // var_dump($check_email['password']);
    // var_dump($check_email['admin_id']);
    // exit;

    // check if password match
    if(!password_verify($password, $check_email['password'])) throw new AppException("Invalid password");

    // create session
    $_SESSION['ADMIN'] = $check_email['admin_id'];

    // redirect to dashboard
    set_alert("Login success");
    redirect("../");
   } 
   catch (AppException $e) 
   {
    set_alert($e->message, $e->type);
    redirect("../login");
   }
}

// log out logic
if (isset($_POST['logout'])) {
    session_destroy();
    redirect("../login");
}